#!/bin/sh
#
# Author: Sami Lehtinen <sjl@ssh.com>
#
# Copyright (C) 2002 SSH Communications Security Corp, Helsinki, Finland
# All rights reserved.
#
# Created: Mon Apr 22 06:46:56 2002
# 
# Keyboard-interactive plugin example script.
#
# Note that this is just an example; you shouldn't use this without 
# modifications. This script doesn't do any useful checks.

echo "Authenticating..." > /dev/stderr
first=yes
while test \( -n "$line" -o -n "$first" \) -a "$line" != "end_of_params"; do
  first=
  read line
  echo "Read line: $line" > /dev/stderr
  if test -n "$line"; then
    param=`echo "$line" | sed -e 's/\([^:]\+\):.*/\1/g'`
    value=`echo "$line" | sed -e 's/[^:]\+://g'`
    echo "Got param \"$param\", value \"$value\"" > /dev/stderr
    if test "$param" = "user_name"; then
      user="$value"
    fi
    if test "$param" = "remote_host_name"; then
      host="$value"
    fi
  fi
done

echo "instruction:Plugin test questions for user $user from $host"
# The answers to these will be echoed by the client.
echo "req_echo:Do you enjoy using ssh2? "
echo "req_echo:Put something here: "
# To this echo is off.
echo "req:4+5?: "
echo "end_of_requests"

read rep1
read rep2
read rep3
read foo

for i in 1 2 3; do
  eval "echo rep$i=\\\"\$rep$i\\\" > /dev/stderr"
done

for i in 1 2 3; do
 cmd="rep$i=\`echo \$rep$i | sed -e 's/^reply:\\(.*\\)/\\1/g'\`"
 eval "$cmd"
done

for i in 1 2 3; do
  eval "echo rep$i=\\\"\$rep$i\\\" > /dev/stderr"
done

if test "$foo" != "end_of_replies"; then
  echo "Replys didn't terminate with \"end_of_replies\"." > /dev/stderr
  echo "Instead, got this: \'$foo\'" > /dev/stderr
fi

echo "instruction:Your input was \"$rep2\""
if test "$rep1" = "yes" -a "$rep3" = "9"; then
  echo "end_of_requests"
else
  echo "failure"
fi

read foo

if test "$foo" != "end_of_replies"; then
  echo "Replys didn't terminate with \"end_of_replies\"." > /dev/stderr
  echo "Instead, got this: \'$foo\'" > /dev/stderr
fi

echo "This example authentication always fails." > /dev/stderr

echo failure

# sshd2 doesn't really care of the exit value, let's return with an error 
# anyway
exit 1
