#!/bin/sh
#
# Author: Sami Lehtinen <sjl@ssh.com>
#
# Copyright (C) 2002 SSH Communications Security Corp, Helsinki, Finland
# All rights reserved.
#
# Created: Wed Apr 17 06:24:39 2002
# 
# External authorization example script.
#
# The user has to be valid, and has to succeed all necessary
# authentications, after which sshd2 will run the program specified with
# ExternalAuthorizationProgram configuration option, if it is set.
#

# sshd2 will output stuff sent to stderr by the authorization program as
# debug. The line below would print with my debug settings, with "-d 2" as
#
#    debug[2106]: ext_auth: Doing authorization
#
echo "Doing authorization" > /dev/stderr

first=yes
while test \( -n "$line" -o -n "$first" \) -a "$line" != "end_of_params"; do
  first=
  read line
  echo "Read line: $line" > /dev/stderr
  if test -n "$line"; then
    param=`echo "$line" | sed -e 's/\([^:]\+\):.*/\1/g'`
    value=`echo "$line" | sed -e 's/[^:]\+://g'`

# Just parse all params up to "end_of_params" and store user name, if it
# is found.
    echo "Got param \"$param\", value \"$value\"" > /dev/stderr
    if test "$param" = "user_name"; then
      user="$value"
    fi
  fi
done

if test "$user" = "sjl"; then
# The param names, or "success" and "failure" messages are treated 
# case-insensitive by sshd2. Values are case-sensitive, however.
  echo "SUCCESS"
elif test "$user" = "testuser"; then
  echo "failure"

# This is the only error_code sshd2 treats specially. If, after the
# authorization program has sent "failure", it also sends an
# "error_code" with value of "password_too_old", sshd2 forces the
# command "passwd" to be executed. (note that you can change that with
# the "PasswdPath" configuration option.)

  echo "error_code:password_too_old"
  echo "error_msg:User $user's password was too old."
  exit 1
else
# Default here is "success". Note that sshd2 will always assume
# authorization is granted with successful authentication, if
# ExternalAuthorizationProgram is not set.

  echo "success"
fi
exit 0
