/*
  t-ttyflags.c

  Author: Sami Lehtinen <sjl@ssh.fi>

  Copyright (c) 1998 SSH Communications Security, Finland
                     All rights reserved

 */

#include "sshincludes.h"
#include "sshttyflags.h"
#include "sshgetopt.h"

#define SSH_DEBUG_MODULE "TestTtyFlags"

void test_debug(const char *msg, void *context)
{
  Boolean verbose = *(Boolean *)context;

  if (verbose)
    fprintf(stderr, "%s\n", msg);
}

void test_warning(const char *msg, void *context)
{
  Boolean verbose = *(Boolean *)context;

  if (verbose)
    fprintf(stderr, "warning: %s\n", msg);
}

int main(int argc, char **argv)
{
  unsigned char *buf = NULL, *buf2 = NULL;
  size_t buf_len = 0, buf2_len = 0;
  Boolean verbose = FALSE;

  while (1)
    {
      int option;
      ssh_opterr = 0;
      ssh_optallowplus = 1;
      
      option = ssh_getopt(argc, argv, "d:v", NULL);
      
      if (option == -1)
        break;

      switch (option)
        {
        case 'd':
          ssh_debug_set_global_level(atoi(ssh_optarg));
          verbose = TRUE;
          break;
        case 'v':
          ssh_debug_set_global_level(2);
          verbose = TRUE;
          break;
        }  
    }

  ssh_debug_register_callbacks(NULL, test_warning, test_debug, &verbose);

  fprintf(stderr, "Running test for sshttyflags, use -v for verbose "
                  "output, and -d <level> to set debug level.\n");

  ssh_encode_tty_flags(fileno(stdin), &buf, &buf_len);

  buf2_len = buf_len;

  buf2 = ssh_xmemdup(buf, buf_len);
  
  SSH_TRACE_HEXDUMP(1, ("encoded ttyflags (buf2)"), buf2, buf2_len);

  ssh_decode_tty_flags(fileno(stdin), buf, buf_len);

  if (buf_len != buf2_len)
    {
      SSH_TRACE(1, ("lengths are different. buf_len = %d, buf2_len = %d",
                    buf_len, buf2_len));
      return 1;
    }

  if (memcmp(buf, buf2, buf_len) != 0)
    {
      SSH_TRACE(1, ("memory areas are different."));
      SSH_TRACE_HEXDUMP(1, ("encoded ttyflags (buf)"), buf, buf_len);
      return 1;
    }

  SSH_TRACE(1, ("Passed all tests."));
  
  return 0;
}
