/*

  sshstdiofilter.h

  Authors:
        Tatu Ylnen <ylo@ssh.com>
        Markku-Juhani Saarinen <mjos@ssh.com>
        Timo J. Rinne <tri@ssh.com>
        Sami Lehtinen <sjl@ssh.com>

  Copyright (C) 1997-2000 SSH Communications Security Corp, Helsinki, Finland
  All rights reserved.


  This module basically implements escape character handling for ssh
  client.

  For Windows command line ssh2.exe, these functions remove the emulation
  codes from the data coming from the server because emulation codes are
  not natively supported by the console.
*/

#ifndef SSHSTDIOFILTER_H
#define SSHSTDIOFILTER_H

#include "sshfilterstream.h"

void ssh_stdio_output_filter(void *context,
                             SshFilterGetCB get_data,
                             SshFilterCompletionCB completed,
                             void *internal_context);

void ssh_stdio_input_filter(void *context,
                            SshFilterGetCB get_data,
                            SshFilterCompletionCB completed,
                            void *internal_context);

void ssh_stdio_filter_destroy(void *context);

#endif /* ! SSHSTDIOFILTER_H */
