/*

sshsocksfilter.h

  Author: Sami J. Lehtinen <sjl@ssh.com>

  Created: Wed Dec 12 16:37:30 2001.

  Copyright (C) 2001 SSH Communications Security Corp, Helsinki, Finland
  All rights reserved.

*/

#ifndef _SSHSOCKSFILTER_H_
#define _SSHSOCKSFILTER_H_

#include "sshstream.h"
#include "sshcommon.h"
#include "sshoperation.h"

typedef void (*SshSocksFilterCompletionCB)(void *context);

SshOperationHandle
ssh_socks_filter_create(SshStream stream, SshCommon common,
                        SshTcpForwardActive forward,
                        SshSocksFilterCompletionCB completion,
                        void *completion_context);

#endif /* !_SSHSOCKSFILTER_H_ */
