/*
  sshfc_transferi.h

  Author: Sami Lehtinen <sjl@ssh.com>

  Copyright (C) 2001, 2002 SSH Communications Security Corp, Helsinki, Finland
  All rights reserved.

  Internal declarations common to SshFCTransfer and SshFCTransferCore.
*/

#ifndef SSHFC_TRANSFERI_H
#define SSHFC_TRANSFERI_H

#include "sshbuffer.h"
#include "sshtimemeasure.h"
#include "sshfsm.h"
#include "sshoperation.h"
#include "sshadt_list.h"

#define SSH_FSM_PROTOTYPES
#include "sshfc_trcore_states.h"

SSH_FSM_STEP(transfer_finish_thread);

typedef struct SshFileCopyTransferContextRec
{
  /* Source connection. */
  SshFileCopyConnection src_conn;
  /* Source location. */
  SshADTContainer file_list;
  /* Destination connection. */
  SshFileCopyConnection dest_conn;
  /* Destination location. (single file. Must be directory, if
     multiple files are transferred. */
  SshFileCopyFile dest_loc;
  /* Transfer attributes. */
  SshFileCopyTransferAttrs attrs;

  /* Callback (and context for it), with which success or failure
     messages are returned to the application. */
  SshFileCopyTransferReadyCB completion_callback;
  SshFileCopyErrorCB error_callback;

  void *callback_context;

  SshFSM fsm;
  SshFSMThread main_thread;

  SshFSMCondition in_blocking;
  SshFSMCondition out_blocking;
  SshFSMThread reader;
  SshFSMThread writer;

  /* ASCII/binary mode stuff. */
  SshFSMCondition mangle_blocking;
  SshFSMThread mangler;
  Boolean mangle_this_file;
  /* Newline mangling. */
  char *src_newline;
  char *dest_newline;
  




  
  /* Timer for single transfers . */
  SshTimeMeasure transfer_timer;
  /* Timer for the whole transfer operation. */
  SshTimeMeasure total_transfer_timer;

  /* Buffers used in transfer. */
  SshADTContainer buf_queue;
  /* Number of buffers in queue. */
  size_t num_bufs;

  /* Operation handle for an SshFileClient operation outside
     sshfc_trcore (that module has an internal way of storing the
     operation handle. */
  SshOperationHandle operation_handle;

  Boolean received_eof;
} *SshFileCopyTransferContext;

typedef struct TransferThreadContextRec
{
  /* XXX Document these. */
  char *src_file_full_path;
  char *basedir;
  
  SshFileCopyFile cur_dest;
  
  SshFileCopyFile cur_loc;
  SshADTHandle h;
  Boolean cur_loc_allocated;
  
  Boolean stat_done;

  SshFSMStepCB after_stat_state;
  
  /* Thread pointers. */
  SshFSMThread parent;
  SshFSMThread child;















  /* Whether we are currently interested in the source or the
     destination file (during stat or remove etc.). TRUE if yes, FALSE
     otherwise. */
  Boolean dealing_with_source;
  
  SshFSMStepCB current_state;
  SshFileCopyFile current_file;
  FCCommonStatusCB status_cb;
  FCCommonHandleCB handle_cb;
  FCCommonDataCB data_cb;
  FCCommonNameCB name_cb;
  FCCommonAttributeCB attrs_cb;
  
  /* Operation handle for the ssh_file_client_* operations, so that we
     can abort them, if we get aborted. */
  SshOperationHandle op_handle;

} *TransferThreadContext;

void transfer_thread_destructor(SshFSM fsm, void *tdata);
void progress_timeout_cb(void *context);

#endif /* SSHFC_TRANSFERI_H */
