/*
  sshauthmethodsi.h

  Author: Sami Lehtinen <sjl@ssh.com>

  Copyright (C) 2001 SSH Communications Security Corp, Helsinki, Finland
  All rights reserved.

  Initialization macros for SSH2 authentication method arrays for both
  server and client.

*/

#ifndef _SSHAUTHMETHODSI_H_
#define _SSHAUTHMETHODSI_H_

#define SSH_AUTH_METHOD_INIT_PROTO(type, function)      \
type function(SshADTContainer conf_methods)

#define SSH_AUTH_METHOD_UNINIT_PROTO(type, function)    \
void function(type methods, void *context)

#define SSH_AUTH_METHOD_INIT(type, function, add_rest)                      \
SSH_AUTH_METHOD_INIT_PROTO(type, function)                                  \
{                                                                           \
  type methods;                                                             \
  SshADTContainer new_list;                                                 \
  SshADTHandle h, hn;                                                       \
  int i = 0, j = 0, k = 0;                                                  \
  char *cur_method = NULL, *existing = NULL;                                \
                                                                            \
  SSH_PRECOND(conf_methods != NULL);                                        \
                                                                            \
  methods = ssh_xcalloc(sizeof(all_methods)/sizeof(*all_methods),           \
                        sizeof(*all_methods));                              \
                                                                            \
  new_list = ssh_adt_create_generic(SSH_ADT_LIST,                           \
                                    SSH_ADT_ARGS_END);                      \
                                                                            \
  /* Remove duplicates from list. */                                        \
  for (h = ssh_adt_enumerate_start(conf_methods);                           \
       h != SSH_ADT_INVALID;                                                \
       h = ssh_adt_enumerate_next(conf_methods, h))                         \
    {                                                                       \
      cur_method = ssh_adt_get(conf_methods, h);                            \
                                                                            \
      for (hn = ssh_adt_enumerate_start(new_list);                          \
           hn != SSH_ADT_INVALID;                                           \
           hn = ssh_adt_enumerate_next(new_list, hn))                       \
        {                                                                   \
          existing = ssh_adt_get(new_list, hn);                             \
          if (strcmp(existing, cur_method) == 0)                            \
            break;                                                          \
        }                                                                   \
                                                                            \
      if (hn == SSH_ADT_INVALID)                                            \
        {                                                                   \
          ssh_adt_insert_to(new_list, SSH_ADT_END, cur_method);             \
          SSH_DEBUG(5, ("Added method \"%s\" to candidates.", cur_method)); \
        }                                                                   \
    }                                                                       \
                                                                            \
  /* Add the approriate methods to the final methods array. */              \
  for (hn = ssh_adt_enumerate_start(new_list);                              \
       hn != SSH_ADT_INVALID;                                               \
       hn = ssh_adt_enumerate_next(new_list, hn))                           \
    {                                                                       \
      cur_method = ssh_adt_get(new_list, hn);                               \
                                                                            \
      for (i = 0; all_methods[i].name != NULL; i++)                         \
        {                                                                   \
          if (strcmp(all_methods[i].name, cur_method) == 0)                 \
            {                                                               \
              methods[j++] = all_methods[i];                                \
              SSH_DEBUG(4, ("Added \"%s\" to usable methods.",              \
                            all_methods[i].name));                          \
            }                                                               \
        }                                                                   \
    }                                                                       \
                                                                            \
  if (add_rest)                                                             \
    {                                                                       \
      /* If needed (i.e. in server) add the rest of the methods last to     \
         the array (needed in, for example, scheme). The methods may, or    \
         may not, be actually used. */                                      \
      for (i = 0; all_methods[i].name != NULL; i++)                         \
        {                                                                   \
          for (k = 0; methods[k].name; k++)                                 \
            if (strcmp(all_methods[i].name, methods[k].name) == 0)          \
              break;                                                        \
                                                                            \
          if (methods[k].name == NULL)                                      \
            {                                                               \
              methods[j++] = all_methods[i];                                \
              SSH_DEBUG(4, ("Added \"%s\" to usable methods.",              \
                            all_methods[i].name));                          \
            }                                                               \
        }                                                                   \
    }                                                                       \
                                                                            \
  ssh_adt_destroy(new_list);                                                \
                                                                            \
  return methods;                                                           \
}

#define SSH_AUTH_METHOD_UNINIT(type, function)                  \
SSH_AUTH_METHOD_UNINIT_PROTO(type, function)                    \
{                                                               \
  SshAuthUninitCtx ctx = (SshAuthUninitCtx)context;             \
                                                                \
  if (ctx && ctx->notify_callback)                              \
    {                                                           \
      SSH_DEBUG(3, ("Calling notification callback."));         \
      (*ctx->notify_callback)(ctx->notify_context);             \
    }                                                           \
                                                                \
  if (ctx)                                                      \
    ssh_xfree(ctx);                                             \
                                                                \
  SSH_DEBUG(5, ("Destroying authentication method array."));    \
  memset(methods, 'F', sizeof(all_methods));                    \
  ssh_xfree(methods);                                           \
}

#endif /* _SSHAUTHMETHODSI_H_ */
