/*

  sshauthmethodc.c

  Authors:
        Tatu Ylonen <ylo@ssh.com>
        Markku-Juhani Saarinen <mjos@ssh.com>
        Timo J. Rinne <tri@ssh.com>
        Sami Lehtinen <sjl@ssh.com>

  Copyright (C) 1997-2001 SSH Communications Security Corp, Helsinki, Finland
  All rights reserved.

  SSH2 authentication methods for the client.

*/

#include "ssh2includes.h"
#include "sshencode.h"
#include "sshauth.h"
#include "sshauthmethods.h"
#include "sshauthmethodsi.h"


#include "readpass.h"


#include "authc-pubkey.h"
#include "authc-passwd.h"


#include "authc-hostbased.h"
#include "authc-kerberos.h"
#include "authc-kerberos-tgt.h"


#ifdef CLIENT_WITH_PAM
#include "authc-pam.h"
#endif /* CLIENT_WITH_PAM */

#ifdef SSH_CLIENT_WITH_SECURID
#include "authc-securid.h"
#endif /* SSH_CLIENT_WITH_SECURID */
#ifdef SSHDIST_SSH2_AUTH_KBDINTERACTIVE
#ifdef SSH_CLIENT_WITH_KEYBOARD_INTERACTIVE
#include "authc-kbd-interactive.h"
#endif /* SSH_CLIENT_WITH_KEYBOARD_INTERACTIVE */
#endif /* SSHDIST_SSH2_AUTH_KBDINTERACTIVE */

#define SSH_DEBUG_MODULE "SshAuthMethodClient"

/* table of the supported authentication methods */

SshAuthClientMethodStruct all_methods[] =
{



  { SSH_AUTH_HOSTBASED, ssh_client_auth_hostbased },


#ifdef CLIENT_WITH_PAM
  { SSH_AUTH_PAM, ssh_client_auth_pam },
#endif /* CLIENT_WITH_PAM */
#ifdef KERBEROS
  { SSH_AUTH_KERBEROS_TGT, ssh_client_auth_kerberos_tgt },
  { SSH_AUTH_KERBEROS, ssh_client_auth_kerberos },
#endif /* KERBEROS */
  { SSH_AUTH_PUBKEY, ssh_client_auth_pubkey },
  { SSH_AUTH_PASSWD, ssh_client_auth_passwd },
#ifdef SSH_CLIENT_WITH_SECURID
  { SSH_AUTH_SECURID, ssh_client_auth_securid },
#endif /* SSH_CLIENT_WITH_SECURID */
#ifdef SSHDIST_SSH2_AUTH_KBDINTERACTIVE
#ifdef SSH_CLIENT_WITH_KEYBOARD_INTERACTIVE
  { SSH_AUTH_KBD_INTERACTIVE, ssh_client_auth_kbd_interact },
#endif /* SSH_CLIENT_WITH_KEYBOARD_INTERACTIVE */
#endif /* SSHDIST_SSH2_AUTH_KBDINTERACTIVE */
  { NULL, NULL_FNPTR }
};

/* Initializes the authentication methods array for the client. */
SSH_AUTH_METHOD_INIT(SshAuthClientMethod,
                     ssh_client_authentication_initialize,
                     FALSE);

/* Frees the returned authentication method array. */
SSH_AUTH_METHOD_UNINIT(SshAuthClientMethod,
                       ssh_client_authentication_uninitialize);

