/*
  sshappcommon.h

  Authors: Sami Lehtinen <sjl@ssh.com>

  Copyright (C) 1999-2001 SSH Communications Security Corp, Helsinki, Finland
  All rights reserved.

  Common functions for all ssh-applications.
*/

#ifndef SSHAPPCOMMON_H
#define SSHAPPCOMMON_H

#include "sshdllist.h"
#include "sshregex.h"

/* Regex syntax used for something else than fileglobbing. */
/* XXX */
#define SSH2_REGEX_SYNTAX SSH_REGEX_SYNTAX_EGREP

/* Function for conveying informational messages to user. The output
   is _not_ followed by a newline. */
int ssh_informational(const char *format, ...);

void ssh_informational_callback_register(int (*callback)
                                         (const char *message, void *context),
                                         void *context);

/* Prints version string to stderr. */
void ssh2_version(const char *name);

/* Registers the program name. */
void ssh_register_program_name(const char *name);

/* Get program name. */
const char *ssh_get_program_name(void);

typedef void (*SshAppListNodeDeleteProc)(void *item);

/* Helper function, that destroys a list, and frees it's contents,
   too. If delete_proc is non-NULL, it is used to delete the list
   item. Otherwise, the item is just ssh_xfree()d. */
void ssh_app_free_list(SshDlList list, SshAppListNodeDeleteProc delete_proc);

/* Gets next token from a list. Tokens are separated by _unescaped_
   commas, so you can have commas in a token, they just have to be
   escaped with '\'. The original 'string' isn't modified, and the
   returned string a newly xmalloced one (which has to freed by the
   caller). */
char *ssh_app_param_list_get_next(const char *string);

/* Gets the global SshRegex context. If not already allocated, allocates it.
   This function will not fail. */
SshRegexContext ssh_app_get_global_regex_context(void);

/* Frees the global regex context. */
void ssh_app_free_global_regex_context(void);

/* Return syslog-style severity from an SshLogSeverity variable. */
int ssh_app_log_severity(SshLogSeverity severity);

/* Return syslog-style facility from an SshLogFacility variable. */
int ssh_app_log_facility(SshLogFacility facility);

/* Return TRUE, if filename is absolute (starts with '/' in UNIX). */
Boolean ssh_app_is_file_name_absolute(const char *filename);

/* Sets the debug format string for the application. If format is NULL, sets
   the default format. */
void ssh_app_set_debug_format(const char *format);

#endif /* SSHAPPCOMMON_H */
