/*

ssh2compat.h

  Author: Sami Lehtinen <sjl@ssh.com>

  Copyright (C) 2001 SSH Communications Security Oy, Espoo, Finland
  All rights reserved.

  Conveniency functions for compatibility with older ssh-versions.
  (intended for compat code that touches both sshproto and apps/ssh)
*/

#ifndef _SSH2COMPAT_H_
#define _SSH2COMPAT_H_

#include "sshcrypt.h"

/* Change public key hashing scheme as needed. Only used with
   RSA-keys. Returns FALSE on success. */
Boolean ssh_compat_rsa_public_key_change_scheme(SshPublicKey pubkey,
                                                Boolean hash_is_sha1);

/* Change private key hashing scheme as needed. Only used with
   RSA-keys. Returns FALSE on success. */
Boolean ssh_compat_rsa_private_key_change_scheme(SshPrivateKey privkey,
                                                 Boolean hash_is_sha1);

/* Returns TRUE for an RSA public key. FALSE otherwise. */
Boolean ssh_compat_is_rsa_public_key(SshPublicKey pubkey);
#endif /* _SSH2COMPAT_H_ */
