/*

  sshhostkeyi.h

  Author: Tomi Salo <ttsalo@ssh.fi>

  Copyright (c) 2001 SSH Communications Security, Finland
  All rights reserved.

  Created Fri Feb 23 21:07:27 2001.

  Internal data structures for handling multiple host keys.

  */

#ifndef SSHHOSTKEYI_H_INCLUDED
#define SSHHOSTKEYI_H_INCLUDED

#include "sshincludes.h"
#include "sshcrypt.h"
#include "sshbuffer.h"
#include "sshadt_list.h"




/* Keypair to be used as a host key.  The public part can be a
   certificate. */
typedef struct SshHostKeyRec {
  char *host_key_file;
  char *public_host_key_file;
  Boolean public_part_is_certificate;
  SshPrivateKey private_host_key;
  SshBuffer public_host_key; /* Public key (or certificate) in binary
                                form, ready to be sent over the
                                network. */
  char *public_key_algorithm; /* Public  key format  in draft-standard
                                 notation */
  Boolean valid; /* If this is FALSE, the structure does not contain a
                    valid key and should not be used. */




} *SshHostKey;

struct SshHostKeysContextRec {
  SshADTContainer keylist;
  char *private_key_file;
  char *public_key_file;
  char *certificate_file;
  SshHostKeyReadCompletion completion; /* Completion cb for key reading */
  void *completion_context; /* Completion ctx for key reading */
  SshLogFacility log_facility; /* Copied from SshConfig structure */
  Boolean valid_keys; /* Whether we have valid keys */














};

#endif /* SSHHOSTKEYI_H_INCLUDED */
