/*

auth-passwd.h

  Authors:
        Tatu Ylonen <ylo@ssh.com>
        Markku-Juhani Saarinen <mjos@ssh.com>
        Timo J. Rinne <tri@ssh.com>
        Sami Lehtinen <sjl@ssh.com>

  Copyright (C) 1997-2000 SSH Communications Security Corp, Helsinki, Finland
  All rights reserved.

*/

#ifndef AUTHS_PASSWD_H
#define AUTHS_PASSWD_H

#include "sshuser.h"

/* Function used to represent an authentication method.  This function
   performs all processing by the authentication method.  An authentication
   method is policy-independent.
     `user'         user name from the (original) authentication request
     `uc'           SshUser object corresponding to `user' or NULL if invalid
     `packet'       method-specific remaining part of the packet
     `session_id'   session identifier
     `session_id_len' length of session identifier
     `state_placeholder' place to store context data between packets
     `longtime_placeholder'  can hold data between authentications
                    (this is per-method)
     `completion_proc'  callback, that notifies the authentication protocol
                        on the result of the authentication method.
     `completion_context' context for `completion_proc'
     `method_context'   passed to the method function */
void ssh_server_auth_passwd(SshAuthServerOperation op,
                            const char *user,
                            SshUser uc,
                            SshBuffer packet,
                            const unsigned char *session_id,
                            size_t session_id_len,
                            void **state_placeholder,
                            void **longtime_placeholder,
                            SshAuthServerCompletionProc completion_proc,
                            void *completion_context,
                            void *method_context);

#endif /* AUTHS_PASSWD_H */
