/*

  authc-pam.h

  Author: Sami Lehtinen <sjl@ssh.com>

  Copyright (C) 2000 SSH Communications Security Corp, Helsinki, Finland
  All rights reserved.

  PAM (Pluggable Authentication Modules) authentication, client side.
  
*/
#ifndef _AUTHC_PAM_H_
#define _AUTHC_PAM_H_

#ifdef CLIENT_WITH_PAM
void ssh_client_auth_pam(SshAuthClientOperation op,
                         const char *user,
                         unsigned int packet_type,
                         SshBuffer packet_in,
                         const unsigned char *session_id,
                         size_t session_id_len,
                         void **state_placeholder,
                         SshAuthClientCompletionProc completion,
                         void *completion_context,
                         void *method_context);
#endif /* CLIENT_WITH_PAM */

#endif /* _AUTHC_PAM_H_ */
