/*

  authc-kbd-interactive.h

  Author: Sami Lehtinen <sjl@ssh.com>

  Copyright (C) 2000 SSH Communications Security Corp, Helsinki, Finland
  All rights reserved.

  Keyboard interactive authentication, client side. Done according to
  draft-ietf-secsh-auth-kbdinteract-01.txt.

*/
#ifndef _AUTHC_KEYBOARD_INTERACTIVE_H_
#define _AUTHC_KEYBOARD_INTERACTIVE_H_

void ssh_client_auth_kbd_interact(SshAuthClientOperation op,
                                  const char *user,
                                  unsigned int packet_type,
                                  SshBuffer packet_in,
                                  const unsigned char *session_id,
                                  size_t session_id_len,
                                  void **state_placeholder,
                                  SshAuthClientCompletionProc completion,
                                  void *completion_context,
                                  void *method_context);

#endif /* _AUTHC_KEYBOARD_INTERACTIVE_H_ */
