/*

t-strmapping.c

Author: Vesa Suontama <vsuontam@ssh.fi>

Copyright (c) 1999 Vesa Suontama <vsuontam@ssh.fi>, Espoo, Finland
                   All rights reserved

Created: Thu Sep  2 11:20:27 1999 vsuontam
Last modified: Thu Sep  2 13:46:53 1999 vsuontam

*/

#include "sshincludes.h"
#include "sshstrmapping.h"
 
int test1(SshMapping m)
{
  #define NUM_ITEMS 5000
  int num = 0, i, array[NUM_ITEMS];
  char tmp_str[1000];
  Boolean c = TRUE;

  for (i = 0; i < NUM_ITEMS; i++)
    {
      array[i] = i;
    }
  
  for (i = 0; i < NUM_ITEMS; i++)
    {
      snprintf(tmp_str, 1000, "TESTSTR%d", i);
      ssh_str_mapping_put(m, tmp_str, &array[i]);
    }

  for (i = 0; i < NUM_ITEMS; i++)
    {
      int *p;
      snprintf(tmp_str, 1000, "TESTSTR%d", i);
      ssh_str_mapping_get(m, tmp_str, &p);
      if (p != &array[i])
        {
          printf("Hash table error at index %d. Key %s\n", i, tmp_str);
          printf("Test Failed");
          return 1;
        }
      
    }

  ssh_str_mapping_reset_index(m);
  do
    {
      int *p;
      char *str;
      c = ssh_str_mapping_get_next(m, &str, &p);
      if (c)
        {
          snprintf(tmp_str, 1000, "TESTSTR%d", *p);
          if (strcmp(tmp_str, str) != 0)
            {
              printf("The string keys do not match. "
                     "Original key %s.\nRetrieved key %s",
                     tmp_str, str);
              return 1;
            }
          num++;
          *p = 0;
        }
      
    }  while(c);

  if (num != NUM_ITEMS)
    {
      
      printf("Not all items iterated\nOnly %d items iterated instead of %d.\n",
             num, NUM_ITEMS);
      return 1;
      
    }

  return 0;
}

int main()
{
  SshMapping m;
  m = ssh_str_mapping_allocate();
  if (test1(m))
    return 1;

  ssh_str_mapping_free(m);

  return 0;
}
