/*

  auths-common.h

  Author: Sami Lehtinen <sjl@ssh.com>

  Copyright (C) 1997-2000 SSH Communications Security Corp, Helsinki, Finland
  All rights reserved.
                  
  Common functions for both pubkey- and password-authentication on the
  server side.

*/

#ifndef AUTHS_COMMON_H
#define AUTHS_COMMON_H

#include "ssh2includes.h"
#include "sshuser.h"
#include "sshcommon.h"
#include "sshdllist.h"
#include "sshregex.h"

/* Convenience function to bind together checking of host and
   user. Use this in every authentication method. Also, if ``*ucp'' is
   NULL, tries to initialize user-struct. If this fails, it is almost
   always because the user doesn't exist. Authentication methods
   should behave the same whether the host or user is denied connect,
   or the authentication methods fail. Returns FALSE if user&host are
   allowed to connect and authenticate.  */
Boolean ssh_server_auth_check(SshUser *ucp, const char *user, SshConfig config,
                              SshCommon common, char *auth_method_name);

/* Use this to check whether specified user is allowed to
   connect. Returns FALSE if allowed.*/
Boolean ssh_server_auth_check_user(SshUser *ucp, const char *user,
                                   SshCommon common);

/* Use this to check whether connects from specified host are
   allowed. Returns FALSE if connects are allowed.*/
Boolean ssh_server_auth_check_host(SshCommon common);

/* Checks whether given host name or ip-address is found in
   list. Returns FALSE if a match is found, and TRUE otherwise. */
Boolean ssh_match_host_in_list(char *host_name, char *host_ip,
                               SshDlList list);

/* Helper function to check whether user (as user name, uid, remote
   host name and remote ip (as string)) matches with a pattern in
   'list'. Uses egrep-like-syntax. Returns TRUE if a match is found,
   and FALSE otherwise. Skips NULL list-entries. */
Boolean ssh_match_user_in_list(const char *user, uid_t uid, 
                               const char *remote_host, const char *remote_ip,
                               SshDlList list,
                               SshRegexContext rex_ctx);

/* Helper function to check whether given 'string' or 'number' matches
   with a pattern in 'list'. Uses egrep-like-syntax. Returns FALSE if a
   match is found, and TRUE otherwise. Skips NULL list-entries. */
Boolean ssh_match_string_or_number_in_list(const char *string,
                                           unsigned long number,
                                           SshDlList list,
                                           SshRegexContext rex_ctx);

#endif /* AUTHS_COMMON_H */
