/*
 * File:	getline.c
 *
 * Author:	Ulli Horlacher (framstag@rus.uni-stuttgart.de)
 *
 * History:	
 * 
 *   23 Jun 97   Framstag       initial version
 *   24 Jun 97   Framstag       better handling of EOF
 *
 * Reads a single line of text from stdin.
 *
 * Copyright  1997 Ulli Horlacher
 * This file is covered by the GNU General Public License
 */

#include <stdio.h>

#include "getline.h"
#include "config.h"

#if defined(SOLARIS2) || defined(LINUX)
  int fileno(FILE *);
#endif

#ifdef HAVE_LIBREADLINE

  #include <unistd.h>
  #include <stdlib.h>

  char *readline(const char *);

  /*
   * getline  - get one line of text from stdin
   * 
   * INPUT:  line  - prompt
   * 
   * OUTPUT: line  - input text line
   * 
   * RETURN: input text line
   */
  char *getline(char *line, int len) {
    char *cp;

    /* is stdin a tty? */
    if (isatty(fileno(stdin))) {
      
      cp=readline(line);
  
      if (!cp || strlen(cp) > len) {
	if (cp) free(cp);
	*line=0;
	return(NULL);
      }
  
      strcpy(line,cp);
      free(cp);
      return(line);
      
    } else /* no tty */
      return(fgets(line,len,stdin));
      
  }

#else

  char *getline(char *line, int len) {
    return(fgets(line,len,stdin));
  }

#endif
