/*
 * File:	utf7encode.c
 *
 * Author:	Ulli Horlacher (framstag@rus.uni-stuttgart.de)
 *
 * History:	
 * 
 *   24 Mar 95   Framstag	initial version
 *   20 Jan 97   GNUish		modified to move to the gnu-style
 *   23 Feb 97   Framstag	modified str_* function names
 *   25 Jun 97   Framstag	better option handling
 *
 * Filter to encode or decode UTF-7.
 *
 * Copyright  1995-1997 Ulli Horlacher
 * This file is covered by the GNU General Public License
 */

#include "config.h"

#include <stdio.h>
#include <stdlib.h>

#include "message.h"	/* information, warning and error messages */
#include "utf7.h"	/* UTF-7 coding */
#include "string.h"     /* extended string functions */

#if defined(HAVE_GETOPT_H)
  #include <getopt.h>
#else
  int getopt(int, char * const *, const char *);
  extern int opterr;
  extern int optind;
  extern int optopt;
  extern char *optarg;
#endif


int usage();

char *prg; 	/* program name */


int main(int argc, char *argv[]) {
  extern int
    optind;
  int
    opt;
  char
    *cp,
    line[MAXLEN],
    tmp[MAXLEN],
    utf_line[LEN_UTF],
    iso_line[LEN_ISO];
  int
    decode;
  FILE *inf;

  decode=-1;
  prg=argv[0];

  if (strstr(prg,"decode")) decode=1;
  if (strstr(prg,"encode")) decode=0;

  while ((opt=getopt(argc,argv,"h?de")) > 0) {
    switch (opt) {
      case ':':
      case 'h':
      case '?': exit(usage());
      case 'd': decode=1;
      case 'e': decode=0;
    }
  }

  if (decode<0) {
    sprintf(tmp,"wrong program name; use %s -d or %s -e",prg,prg);
    message(prg,'F',tmp);
  }
    
  if (argc-optind==0)
    inf=fdopen(0,"r");
  else {
    inf=fopen(argv[optind],"r");
    if (inf==NULL) {
      sprintf(tmp,"cannot open %s",argv[optind]);
      message(prg,'F',tmp);
    }
  }

  while (fgets(line,MAXLEN-1,inf)) {
    if ((cp=strchr(line,'\n'))) *cp=0;
    if (decode) {
      utf2iso(0,iso_line,tmp,tmp,line);
      printf("%s\n",iso_line);
    }
    else {
      iso2utf(utf_line,line);
      printf("%s\n",utf_line);
    }
  }

  exit(0);
}


/* void function for message() */
void cleanup() { }


/*
 * usage - print short help usage text
 */
int usage() {
  fprintf(stderr,"usage:  %s [-d] [-e] [text-file]\n",prg);
  fprintf(stderr,"option: -d  decode\n");
  fprintf(stderr,"option: -e  encode\n");
  return(2);
}
