/*
 * File:	config.h
 * 
 * Author:	Ulli Horlacher (framstag@rus.uni-stuttgart.de)
 * 
 * History:	12 Aug 95   Framstag	initial version
 *              24 Oct 95   Framstag	changed SAFT-port
 *              21 Dec 95   Framstag	new default for nosendfile: 
 *					/usr/local/etc/
 *              24 Jan 96   Framstag	added MAIL, CONFIG and DATEFORMAT
 * 
 * Various definitions for the sendfile package.
 * 
 * This file is covered by the GNU General Public License
 */

/* 
 * The first 3 defines are the directories where sendfile will be installed.
 * Only the Makefile will use them.
 */

#define BINDIR		"/usr/local/bin"
#define MANDIR		"/usr/local/man/man1"
#define SERVERDIR	"/usr/local/sbin"

#define SPOOL    	"/var/spool/sendfile"
#define NOSENDFILE	"/usr/local/etc/nosendfile"
#define CONFIG		"/usr/local/etc/sendfile.cf"


/* ############ You should not change anything after this line ############ */


#define DATEFORMAT	"%d-%b-%Y %H:%M:%S"	/* see strftime(3) */
#define CHARSET		"ISO_8859-1:1987"	/* this is ISO Latin 1 */
#define VERSION		"sendfiled 1.4"
#define REVISION	"19960221"
#define PROTOCOL 	"SAFT"
#define SAFT	  	487	/* SAFT tcp port */
#define OVERSIZE  	32768	/* string oversize length */
#define MAXLEN	  	1024	/* max length of various strings */
#define PACKET	  	512	/* data size per packet */
#define DLEN	  	30	/* date string length */
#define FLEN	  	256	/* file/directory name length */
#define DEBUG			/* more debugging output */
#undef  DEBUG
#define ALT_MESSAGES		/* alternative message format */
#undef  ALT_MESSAGES

#if defined(HPUX)
  #define MAIL	"mailx"	/* the original BSD mail, NOT elm! */
#else
  #define MAIL	"Mail"	/* the original BSD mail, NOT elm! */
#endif

#ifdef NEXT
  #ifndef _NEXT_SOURCE
    #define _NEXT_SOURCE
  #endif
#endif

#if defined(AIX) || defined(LINUX)
  #define SYSV
#endif

#if defined(SOLARIS1) || defined(CONVEXOS)
  #define BSD
#endif

#ifdef __svr4__
  #ifndef SYSV
    /* Stupid Solaris 2.0 machines define __svr4__ but not SYSV */
    #define SYSV
  #endif
#endif

#ifdef SVR3
  #ifndef SYSV
    /* Stupid SGI machines define SVR3 but not SYSV */
    #define SYSV
  #endif
#endif

#ifdef __hpux
  /* Basically SYSV */
  #define SYSV
#endif

/*
#ifdef SYSV
  #define killpg(a, b) kill(-(a), (b))
  #define bcopy(a, b, c) memcpy(b, a, c)
  #define bzero(a, b) memset(a, 0, b)
  #define bcmp memcmp
  #define index strchr
  #define rindex strrchr
  #define initstate srand
  #define random rand
  #define sigtype void
#endif
*/

/* Solaris, at least, has better versions of some functions */
#ifdef __svr4__
  #define bcopy(a, b, c) memmove(b, a, c)
  #define initstate srand48
  #define random lrand48
#endif

#ifndef sigtype
  #ifdef NEXT
    #define sigtype void
  #else
    #define sigtype int
  #endif
#endif
