/*
 * File:	spool.h
 * 
 * Author:	Ulli Horlacher (framstag@rus.uni-stuttgart.de)
 * 
 * History:	 1 Sep 95	  Framstag	initial version
 * 
 * Header-file for functions for operations on files in the sendfile spool 
 * directory.
 * 
 * This file is covered by the GNU General Public License
 */


/* attribute flags */
#define F_SOURCE        1
#define F_TEXT          2
#define F_COMPRESS      4
#define F_TAR           8


/* list of all files from one sender */
struct filelist {
  int id,			/* id number */
      osize,			/* original size */
      csize,			/* compressed size */
      tsize,			/* transfered size */
      flags;			/* binary, source, text, compress and tar flag */
  char rdate[DLEN+1],		/* receiving date */
       date[DLEN+1],		/* file date */
       charset[DLEN+1],		/* character set name */
       fname[MAXLEN];		/* UTF-7 file name */
  struct filelist *next;	/* next list element */
};

/* list of all senders */
struct senderlist {
  char from[MAXLEN],		/* sender */
       sig[MAXLEN];		/* authentification signature */
  struct senderlist *next;	/* next list element */
  struct filelist *flist;	/* list of files */
};


/* send string conforming to NVT telnet standard */
void out(const char *);	

/* scan the spool directory and create structure lists */
struct senderlist *scanspool(const char *);

/* create new sender list element and fill it out */
struct senderlist *newsle(struct filelist *, const char *, const char *);

/* delete a spool file */
int delete_sf(struct filelist *, int);
