/*
 * File:	io.c
 * 
 * Author:	Ulli Horlacher (framstag@rus.uni-stuttgart.de)
 * 
 * History:	11 Aug 95   Framstag	initial version
 * 
 * Socket read and write routines of the sendfile package.
 * 
 * This file is covered by the GNU General Public License
 */

#include <unistd.h>
#include <sys/types.h>

#ifdef NEXT
  #include <sys/uio.h>
#endif

/*
 * readn - read n bytes from network socket
 * 
 * INPUT:  fd     - socket file descriptor
 *         ptr    - empty string
 *         nbytes - number of bytes to read
 * 
 * RETURN: number of actual read bytes
 * 
 * this function is derived from example code from
 * "Unix Networking Programming" by W. R. Stevens
 */
int readn(int fd, char *ptr, int nbytes) 
{ int nleft, nread;
  
  nleft=nbytes;
  while (nleft>0) 
  { nread=read(fd, ptr, nleft);
    if (nread<0) 
      return(nread);
    else
      if (nread==0) break;
    nleft-=nread;
    ptr+=nread;
  }
  return(nbytes-nleft);
}


/*
 * writen - write n bytes to network socket
 * 
 * INPUT:  fd     - socket file descriptor
 *         ptr    - string to send
 *         nbytes - number of bytes to send
 * 
 * RETURN: number of actual written bytes
 * 
 * this function is derived from example code from
 * "Unix Networking Programming" by W. R. Stevens
 */
int writen(int fd, char *ptr, int nbytes) 
{ int nleft, nwritten;
  
  nleft=nbytes;
  while (nleft>0) 
  { nwritten=write(fd, ptr, nleft);
    if (nwritten<0) return(nwritten);
    nleft-=nwritten;
    ptr+=nwritten;
  }
  return(nbytes-nleft);
}
