/*
 * File:	string.c
 * 
 * Author:	Ulli Horlacher (framstag@rus.uni-stuttgart.de)
 * 
 * History:	12 Aug 95   Framstag	initial version
 * 
 * Extended string functions for the sendfile package, which are not found
 * in the standard C library.
 * Look at string.h for a list of the functions.
 * 
 * This file is covered by the GNU General Public License
 */


#include <string.h>
#include <stdlib.h>
#include <ctype.h>

#include "string.h"

/*
#ifdef IRIX
  int toupper(char);
  int tolower(char);
#endif
*/

/* 
 * str_trim - substitute multiple white spaces with one space
 *            and delete heading and trailing whitespace
 * 
 * INPUT:  string  - string to trim
 * 
 * OUTPUT: string  - trimmed string
 * 
 * RETURN: trimmed string
 */
char *str_trim(char *string) 
{ char *tmp,	/* tmp-string */
       *sp,	/* pointer of read string */
       *tp;	/* pointer of write string */
  int ws=0;	/* white space flag */
  
  /* create temp-string for intermediate storage */
  tmp = (char *) malloc(strlen(string)+1);
  *tmp = 0;
  tp = tmp;
  
  /* loop over string */
  for (sp=string; *sp!=0; sp++) 
  { 
    /* is it a white space? */
    if (*sp==' ' || *sp=='\t') 
    { 
      /* was the last character not a white space? */
      if (ws==0)  
      { 
	/* store a blank */
	*tp++ = ' ';
	ws = 1;
      }
    } else 
    { 
      /* store the character */
      *tp++ = *sp;
      ws = 0;
    }
  }

  *tp = 0;
  
  /* delete leading and trailing blanks */
  if (*tmp==' ') tmp++;
  if (ws) *(--tp) = 0;

  /* restore the string and free memory */
  strcpy(string,tmp);
  free(tmp);

  return(string);
}


/*
 * str_toupper - transform string to upper case
 * 
 * INPUT:  string  - string to transform
 * 
 * OUTPUT: string  - transformed string
 * 
 * RETURN: string  - transformed string
 */
char *str_toupper(char *string)  
{ char *cp;
  
  /* change each character to it's upper case pedant */
  for (cp=string; *cp!=0; cp++) *cp = (char) toupper(*cp);
  
  return(string);
}


/*
 * str_tolower - transform string to lower case
 * 
 * INPUT:  string  - string to transform
 * 
 * OUTPUT: string  - transformed string
 * 
 * RETURN: string  - transformed string
 */
char *str_tolower(char *string)  
{ char *cp;
  
  /* change each character to it's upper case pedant */
  for (cp=string; *cp!=0; cp++) *cp = (char) tolower(*cp);
  
  return(string);
}


/* insert one string in another */
void strins(char *to, char *from) 
{ while (*from) *to++ = *from++; }


/***************************************************************
 * 
 *  simplematch:  Einfaches Wildcard-Matching.
 *
 *  ?           matcht jedes beliebige Zeichen
 *  *           matcht eine beliebig lange Folge von beliebigen Zeichen
 *  [abc]  	matcht 'a', 'b' und 'c'
 *              innerhalb [] gelten '?', '*' und '[' als normale Zeichen
 *  \?          testet auf "echtes" '?'   Alternative:  [?]
 *  \*          testet auf "echtes" '*'   Alternative:  [*]
 *  \[          testet auf "echtes" '['   Alternative:  [[]
 *              ']' gilt ausserhalb [] als normales Zeichen, wenn es 
 *              innerhalb [] verwendet werden soll muss ein \ davor
 *  \n          NewLine
 *  \r          Return
 *  \t          Tabulator
 *  \\          Schraegstrich
 *
 *  ACHTUNG:
 *  Matching auf "[]" (leere Klammer) schlaegt immer fehl
 *
 *  26/Jul/1991 Ingo.Wilken@informatik.uni-oldenburg.de
 */

/*
#include <stddef.h>
#define NULL        (char *)0
*/

#define SM_MATCH	1
#define SM_NOMATCH      0
#define SM_ERROR        -1        /* Fehler im Pattern */


static char sm_escchar(char c)

{ switch( c ) {
        case 'n': c = '\n'; break;
        case 'r': c = '\r'; break;
        case 't': c = '\t'; break;
    }
    return(c);
}


int simplematch(char *text, char *pattern, int nocase)
{
    char *retrypat = NULL, *retrytxt = NULL;
    register char c;
    int notfound;

    while( *text || *pattern ) {
        c = *(pattern++);
        if( nocase )
            c = tolower(c);

        switch( c ) {
            case '*' :  
                retrypat = pattern;
                retrytxt = text;
                break;
            case '[' :  
                notfound = 1;
                while( (c = *(pattern++)) != ']' ) {
                    if( c == '\\' )
                        c = sm_escchar(*(pattern++));
                    if( c == '\0' )
                        return(SM_ERROR);
                    if( *text == c || (nocase && tolower(*text) == c) )
                        notfound = 0;
                }
                if( notfound ) {
                    pattern = retrypat;
                    text = ++retrytxt;
                }
            case '?' :  
                if( *(text++) == '\0' )
                    return(SM_NOMATCH);
                break;
            case '\\':  
                c = sm_escchar(*(pattern++));
                if( c == '\0' )
                    return(SM_ERROR);
            default  :        
                if( *text == c || (nocase && tolower(*text) == c) ) {
                    if( *text )
                        text++;
                }
                else {
                    if( *text ) {
                        pattern = retrypat;
                        text = ++retrytxt;
                    }
                    else
                        return(SM_NOMATCH);
                }
                break;
        }
        if( pattern == NULL )
            return(SM_NOMATCH);
    }
    return(SM_MATCH);
}
