/*
 * File:	sendmsg.c
 * 
 * Author:	Ulli Horlacher (framstag@rus.uni-stuttgart.de)
 * 
 * History:	11 Aug 95   Framstag	initial version
 *              12 Aug 95   Framstag	elm alias support
 *               2 Nov 95   Framstag	added minimal chat mode
 * 
 * The sendmessage client of the sendfile package.
 * Sends a single line text message to the SAFT-server of the destination
 * system to be displayed on the recipients terminal.
 * 
 * This file is covered by the GNU General Public License
 */


#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <errno.h>
#include <fcntl.h>
#include <pwd.h>
#include <sys/stat.h>

#include "config.h"		/* various #defines */
#include "net.h"		/* the network routines */
#include "io.h"			/* (socket) read/write */
#include "message.h"		/* information, warning and error messages */
#include "utf7.h"		/* UTF-7 coding */
#include "destination.h"	/* check recipient and host */

#ifndef AIX
  #if defined(IRIX) || defined(LINUX)
    #include <getopt.h>
  #else
    int getopt(int, char * const *, const char *);
  #endif
#endif


/* print short help usage text */
int usage();


/* global variables */
int verbose;		/* flag for verbose mode */
char *prg;		/* name of the game */


int main(int argc, char *argv[]) {
  extern int optind;	/* number of scanned args with getopt */
  int  sockfd,		/* socket file descriptor */
       chat,		/* flag for chat mode */
       opt;		/* option to test for */
  char recipient[FLEN], /* recipient at serverhost */
       user[FLEN], 	/* local user name */
       host[FLEN], 	/* name of serverhost */
       *reply,		/* reply string from server */
       *cp,		/* simple character pointer */
       tmp[MAXLEN];	/* temporary string */
  unsigned char utf_msg[LEN_UNI],	/* msg in UTF-7 format */
                iso_msg[LEN_ISO];	/* msg in ISO Latin-1 format */

  prg = argv[0];
  verbose = 0;
  chat = 0;

  /* scan the command line on options */
  while ((opt = getopt(argc,argv,"cvh?")) > 0) {
    switch (opt) {
      case ':':
      case 'h':
      case '?': exit(usage());
      case 'v': verbose = 1; break;
      case 'c': chat = 1;
    }
  }

  /* too few arguments? */
  if (argc-optind<1) exit(usage());

  /* get own user name, recipient name and host */
  destination(argc,argv,user,recipient,host);
  
  /* initate the connection to the server */
  sockfd = open_connection(host,PORT);
  reply = getreply(sockfd);
  
  /* protocol error? */
  if (strncmp(reply,"220 ",4)!=0 || strstr(reply," SAFT ")==NULL) {
    errno = 0;
    message(prg,'F',"remote protocol error");
  }

  /* send FROM and TO headers */
  sprintf(tmp,"FROM %s",user);
  if (sendheader(sockfd,tmp)<0) exit(1);
  sprintf(tmp,"TO %s",recipient);
  if (sendheader(sockfd,tmp)<0) exit(1);

  do {
    /* read the message */
    printf("message: ");
    *iso_msg=0;
    fgets(iso_msg,LEN_ISO,stdin);

    /* message empty? */
    if (*iso_msg==0) break;

    /* strip off new line */
    if (*iso_msg=='\n') *iso_msg=' ';
    cp=strrchr(iso_msg,'\n');
    if (cp && (cp!=(char *)iso_msg)) *cp=0;

    /* encode to UTF-7 */
    iso2utf(utf_msg,iso_msg);
      
    /* send the message */
    sprintf(tmp,"MSG %s",utf_msg);
    sendheader(sockfd,tmp);
  } while (chat);
  
  /* close the connection */
  sock_putline(sockfd,"QUIT");
  getreply(sockfd);
  close(sockfd);

  exit(0);
}


/*
 * usage - print short help usage text
 */
int usage() {
  fprintf(stderr,"usage: %s [-v] user[@host]\n",prg);
  fprintf(stderr,"   -v  verbose mode\n");
  return(2);
}
