/*
 * File:	destination.c
 * 
 * Author:	Ulli Horlacher (framstag@rus.uni-stuttgart.de)
 * 
 * History:	12 Aug 95   Framstag	initial version
 *               7 Nov 95   Framstag	added URL addressing
 * 
 * Determine own username, recipient username and host and look
 * for an elm alias in ~/.elm/aliases.text.
 * 
 * This file is covered by the GNU General Public License
 */


#include <stdio.h>
#include <pwd.h>
#include <string.h>
#include <unistd.h>

#include "config.h"		/* various #defines */
#include "utf7.h"		/* UTF-7 coding */
#include "message.h"		/* information, warning and error messages */
#include "destination.h"	/* check recipient and host */


/* noone has strncasecmp defined? */
int strncasecmp(const char *, const char *, size_t);


void destination(int argc, char **argv, 
		 char *user, char *recipient, char *host) {
  char *cp,			/* simple char pointer */
       *at, 			/* @ character in recepient@host */
       *larg,			/* last argument */
       gecos[FLEN],		/* user real name */
       aliasfile[MAXLEN],	/* the elm alias file */
       line[MAXLEN],		/* one line of the elm alias file */
       address[MAXLEN];		/* address from the elm alias */
  extern char *prg;		/* name of the game */
  FILE *inf;			/* input file to read */
  struct passwd *pwe;		/* password entry */
  
  *address = 0;
  
  /* get the own user name */
  if ((pwe=getpwuid(getuid())) == NULL)
    message(prg,'F',"could not determine own user name");
  
  /* translate the real name to UTF-7 and add it */
  iso2utf(gecos,pwe->pw_gecos);
  if ((cp=strchr(gecos,','))) *cp=0;
  sprintf(user,"%s %s",pwe->pw_name,gecos);
   
  larg = argv[argc-1];

  /* user@host specified? */
  if ((at=strchr(larg,'@'))) {
  
    /* store recipient name and host */
    *recipient = 0;
    strncat(recipient,larg,at-larg);
    strcpy(host,at+1);
    
  /* URL specified? */
  } else if (strncasecmp(larg,"saft://",7)==0) {
    larg += 7;
    cp = strrchr(larg,'/');
    strcpy(recipient,cp+1);
    *cp = 0;
    while ((cp=strchr(larg,'/'))) *cp='.';
    strcpy(host,larg);

  /* local user specified */
  } else {
    
    /* store local recipient name and local host */
    strcpy(recipient,argv[argc-1]);
    strcpy(host,"127.0.0.1");

    /* build the elm alias file name */
    sprintf(aliasfile,"%s/.elm/aliases.text",pwe->pw_dir);

    /* if there is an elm alias file, open it (what else? :-) ) */
    if ((inf=fopen(aliasfile,"r"))) {
    
      /* loop over all lines */
      while (fgets(line,MAXLEN,inf)) {
      
        /* cut off trailing new line char */
        if ((cp=strchr(line,'\n'))) *cp = 0;
      
        /* save the address */
        strcpy(address,strrchr(line,' ')+1);
        cp = strchr(line,' ');
      
        /* is it the correct alias, we are ready */
        if (cp) *cp = 0;
        if (strcmp(recipient,line)==0) 
          break;
        else
          *address = 0;

      }
      fclose(inf);
    }

    /* elm alias found? */
    if (*address) {

      /* store recipient name and host */
      at = strchr(address,'@');
      strcpy(host,at+1);
      *at = 0;
      strcpy(recipient,address);

    }
  }
}
