/*
 * File:	config.h
 * 
 * Author:	Ulli Horlacher (framstag@rus.uni-stuttgart.de)
 * 
 * History:	12 Aug 95   Framstag	initial version
 *              24 Nov 95   Framstag	changed SAFT-port
 * 
 * Various definitions for the sendfile package.
 * 
 * This file is covered by the GNU General Public License
 */


#define VERSION  	"sendfiled 1.2"
#define PROTOCOL 	"SAFT 2.0"
#define SPOOL    	"/var/spool/sendfile"
#define NOSENDFILE 	"/etc/nosendfile"
#define CHARSET	 	"ISO_8859-1:1987"
#define BELL	 "\007"	/* ring the gong when a message arrives */
#define MAXFILES  999	/* maximum allowed files to receive per user */
#define PORT	  487	/* SAFT port */
#define OVERSIZE  32768	/* string oversize length */
#define MAXLEN	  512	/* max length of various strings */
#define PACKET	  512	/* data size per packet */
#define DLEN	  30	/* date string length */
#define FLEN	  256	/* file/directory name length */
#define DEBUG		/* more debugging output */
#undef  DEBUG

#ifdef NEXT
  #ifndef _NEXT_SOURCE
    #define _NEXT_SOURCE
  #endif
#endif

#ifdef AIX
  #define SYSV
#endif

#ifdef __svr4__
  #ifndef SYSV
    /* Stupid Solaris 2.0 machines define __svr4__ but not SYSV */
    #define SYSV
  #endif
#endif

#ifdef LINUX
  #define SYSV /* Linux is SysV */
#endif

#ifdef SVR3
  #ifndef SYSV
    /* Stupid SGI machines define SVR3 but not SYSV */
    #define SYSV
  #endif
#endif

#ifdef __hpux
  /* Basically SYSV */
  #define SYSV
#endif

/*
#ifdef SYSV
  #define killpg(a, b) kill(-(a), (b))
  #define bcopy(a, b, c) memcpy(b, a, c)
  #define bzero(a, b) memset(a, 0, b)
  #define bcmp memcmp
  #define index strchr
  #define rindex strrchr
  #define initstate srand
  #define random rand
  #define NO_RLIMITS 1
  #define sigtype void
#endif
*/

/* Solaris, at least, has better versions of some functions */
#ifdef __svr4__
  #define bcopy(a, b, c) memmove(b, a, c)
  #define initstate srand48
  #define random lrand48
#endif

#ifndef sigtype
  #ifdef NEXT
    #define sigtype void
  #else
    #define sigtype int
  #endif
#endif
