/*
 * File:	netio.h
 *
 * Author:	Ulli Horlacher (framstag@rus.uni-stuttgart.de)
 *
 * History:	
 *
 *   1995-08-12 Framstag	initial version
 *   1996-04-23 Framstag	added file copying function
 *   2001-01-10 Framstag	added rfopen()
 *
 * Header-file for the read and write routines of the sendfile package.
 *
 * Copyright  1995 Ulli Horlacher
 * This file is covered by the GNU General Public License
 */


/* read n bytes from network socket */
int readn(int, char *, int);

/* write n bytes to network socket */
int writen(int, char *, int);

/* copy a file */
int fcopy(const char *, const char *, mode_t);

/* where is a program in the path */
char *whereis(char *);

/* open a regular file */
FILE *rfopen(const char *, const char *);

/* mktmpdir - create a new temporary directory */
char *mktmpdir(int);

/* rmtmpdir - delete the temporary directory */
void rmtmpdir(char *);
