#!/bin/sh

# Script to set up a basic CA directory structure, files, certificate
# and key.

CA_DIR="/var/ssl/CA"

if [ -d $CA_DIR ] ; then
	echo "$CA_DIR already exists"
	exit 1
fi

mkdir $CA_DIR || exit 1

cd $CA_DIR || exit 1

echo "Generating CA key..."
openssl genrsa -rand /dev/random -des3 -out ca.key 1024 || exit 1

echo ""

echo "Generating CA certificate..."
openssl req -new -x509 -days 365 -key ca.key -out ca.crt || exit 1

echo ""

echo "Setting up CA environment..."
echo "01" > ca.serial || exit 1
touch ca.index || exit 1
cat > ca.config << EOF
[ ca ]
default_ca              = CA_own
[ CA_own ]
dir                     = .
certs                   = \$dir
new_certs_dir           = \$dir
database                = \$dir/ca.index
serial                  = \$dir/ca.serial
RANDFILE                = \$dir/ca.rand
certificate             = \$dir/ca.crt
private_key             = \$dir/ca.key
default_days            = 365
default_crl_days        = 30
default_md              = md5
preserve                = no
policy                  = policy_anything
[ policy_anything ]
countryName             = optional
stateOrProvinceName     = optional
localityName            = optional
organizationName        = optional
organizationalUnitName  = optional
commonName              = supplied
emailAddress            = optional
EOF

echo "Your CA is ready in $CA_DIR"
