#!/bin/sh

# Script to create a certificate and key file and

CA_DIR="/var/ssl/CA"

if [ ! -d $CA_DIR ] ; then
	echo "$CA_DIR does not exist"
	exit 1
fi

cd $CA_DIR || exit 1

if [ -f server.key ] ; then
	echo "server.key already exists, rename it first"
	exit 1;
fi

echo "Generating server key..."
openssl genrsa -rand /dev/random -out server.key 1024 || exit 1

echo ""

echo "Generating certificate request..."
openssl req -new -days 365 -key server.key -out server.csr || exit 1

echo ""

echo "Signing certificate request (please enter CA passphrase when asked) ..."
openssl ca -config ca.config -out server.crt -infiles server.csr || exit 1

echo ""

echo "Verifying certificate... "
openssl verify -CAfile ca.crt server.crt || exit 1

echo ""

echo "Building key files... "
cat server.key server.crt > server.pem || exit 1
chmod 0600 server.pem

echo ""

echo "You server cert is ready: server.pem"
