#!/bin/sh

# Script to create a certificate and key file and a oneline file

CA_DIR="/var/ssl/CA"

if [ ! -d $CA_DIR ] ; then
	echo "$CA_DIR does not exist"
	exit 1
fi

cd $CA_DIR || exit 1

if [ -f new.key ] ; then
	echo "new.key already exists, rename it first"
	exit 1;
fi

echo "Generating new key..."
openssl genrsa -rand /dev/random -out new.key 1024 || exit 1

echo ""

echo "Generating certificate request..."
openssl req -new -days 365 -key new.key -out new.csr || exit 1

echo ""

echo "Signing certificate request (please enter CA passphrase when asked) ..."
openssl ca -config ca.config -out new.crt -infiles new.csr || exit 1

echo ""

echo "Verifying certificate... "
openssl verify -CAfile ca.crt new.crt || exit 1

echo ""

echo "Adding a password to your key..."
openssl rsa -des3 -in new.key -out new.key.pass || exit 1

echo ""

echo "Building key files... "
cat new.key.pass new.crt > new.pem || exit 1
openssl x509 -subject -in new.pem -noout | cut -c9- > new.subject || exit 1
openssl x509 -issuer -in new.pem -noout | cut -c9- > new.issuer || exit 1
chmod 0600 new.pem new.subject new.issuer

echo ""

echo "You key files are ready: new.pem new.subject new.issuer"
