#!/bin/sh

# Script to symlink X509 certificates to their hashes

CA_DIR="/var/ssl/certs"

# Remove old hashes
rm -f $CA_DIR/[0-9a-fA-F]*.[0-9]*

for CERTFILE in $CA_DIR/*.{crt,pem} ; do
	if [ -r $CERTFILE ] ; then
		HASH=`openssl x509 -noout -hash < $CERTFILE`

		INDEX=0
		while [ 1 ] ; do
			[ ! -L "$CA_DIR/$HASH.$INDEX" ] && break
			INDEX=`expr $INDEX + 1`
		done
		
		ln -sf $CERTFILE "$CA_DIR/$HASH.$INDEX"
		echo "$CERTFILE => $HASH.$INDEX"
	fi
done
