/*
 *   slush		 SSL remote shell
 *   Copyright (c) 1999 Damien Miller <damien@ibs.com.au>
 *				 All Rights Reserved
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _CONTROL_H
#define _CONTROL_H

#include <ssl.h>
#include <sys/ioctl.h>

typedef struct
{
	char *name;
	char *value;
} env_entry_t;

typedef struct
{
	char			password[64];
	char			username[32];
	env_entry_t	*env;
	int			num_env_entries;
	struct winsize *w;	
} control_t;

#define CONTROL_RECV_USERNAME				1
#define CONTROL_RECV_PASSWORD_REQUEST	2
#define CONTROL_RECV_PASSWORD				4
#define CONTROL_RECV_ENVIRONMENT			8
#define CONTROL_RECV_WINSIZE				16
#define CONTROL_RECV_TERM_NEG				32

#define CONTROL_SEND_USERNAME				1
#define CONTROL_SEND_PASSWORD_REQUEST	2
#define CONTROL_SEND_PASSWORD				4
#define CONTROL_SEND_ENVIRONMENT			8
#define CONTROL_SEND_WINSIZE				16
#define CONTROL_SEND_TERM_NEG				32
#define CONTROL_SEND_NOOP					64

/* Checks a block of data revieved from the peer for control messages */
/* if control messages are found, they are interpreted and the ctrl */
/* structure updated. The buffer and buffer_len are also modified */
/* to remove the control message itself */
/* Returns 0 on no control message */
/* or one or more CONTROL_something constants OR'd when one is recieved */
int check_for_control(SSL *ssl, char **buffer, int *buffer_len, control_t *ctrl);

/* Sends a control message containing one or more control types */
/* Control types are OR'd together */
void send_control(SSL *ssl, int control_types, control_t *ctrl);

/* Checks through buffer escaping any control characters therein */
/* Returns new buffer containing escaped representation of original */
/* Buffer and modifies buffer_len to new length of buffer */
char *escape_buffer(char *buffer, int *buffer_len);

#endif
