/*
 *   slush		 SSL remote shell
 *   Copyright (c) 1999 Damien Miller <damien@ibs.com.au>
 *				 All Rights Reserved
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _COMMON_H
#define _COMMON_H

#include <openssl/ssl.h>

#define CLIENT 1
#define SERVER 2

/* Set up a new SSL context */
SSL_CTX *setup_ssl_context(char *cert_file, char *key_file, int verify,
									int method_flag, char *error_buf, int error_len);

/* Initialise SSL */
void init_ssl(void);

/* Connect to remote host */
int connect_to_remote(char *host, int port, char *error_buf, int error_len);

/* Find and open a pty master, return slave pty name */
int get_pty_master(char **slave_name, char *error_msg, int error_len);

/* Open and set up ownership of slave pty */
int get_pty_slave(char *slave_name, int uid, char *error_msg, int error_len);

#endif
