#ifndef CLASS_DEFINE
struct userauth_service
{
  struct ssh_service super;
  struct int_list *advertised_methods;
  struct alist *methods;
};
extern struct lsh_class userauth_service_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_userauth_service_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct userauth_service *i = (struct userauth_service *) o;
  mark((struct lsh_object *) i->advertised_methods);
  mark((struct lsh_object *) i->methods);
}

struct lsh_class userauth_service_class =
{ STATIC_HEADER,
  &ssh_service_class, "userauth_service", sizeof(struct userauth_service),
  do_userauth_service_mark,
  NULL
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct userauth_handler
{
  struct packet_handler super;
  int attempts;
  struct int_list *advertised_methods;
  struct alist *methods;
};
extern struct lsh_class userauth_handler_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_userauth_handler_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct userauth_handler *i = (struct userauth_handler *) o;
  mark((struct lsh_object *) i->advertised_methods);
  mark((struct lsh_object *) i->methods);
}

struct lsh_class userauth_handler_class =
{ STATIC_HEADER,
  &packet_handler_class, "userauth_handler", sizeof(struct userauth_handler),
  do_userauth_handler_mark,
  NULL
};
#endif /* !CLASS_DECLARE */

