#ifndef GABA_DEFINE
struct io_listen_callback
{
  struct io_callback super;
  struct io_backend *backend;
  struct command_continuation *c;
  struct exception_handler *e;
};
extern struct lsh_class io_listen_callback_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_io_listen_callback_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct io_listen_callback *i = (struct io_listen_callback *) o;
  mark((struct lsh_object *) i->backend);
  mark((struct lsh_object *) i->c);
  mark((struct lsh_object *) i->e);
}

struct lsh_class io_listen_callback_class =
{ STATIC_HEADER,
  &io_callback_class, "io_listen_callback", sizeof(struct io_listen_callback),
  do_io_listen_callback_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct io_connect_callback
{
  struct io_callback super;
  struct command_continuation *c;
};
extern struct lsh_class io_connect_callback_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_io_connect_callback_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct io_connect_callback *i = (struct io_connect_callback *) o;
  mark((struct lsh_object *) i->c);
}

struct lsh_class io_connect_callback_class =
{ STATIC_HEADER,
  &io_callback_class, "io_connect_callback", sizeof(struct io_connect_callback),
  do_io_connect_callback_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct exc_finish_read_handler
{
  struct exception_handler super;
  struct lsh_fd *fd;
};
extern struct lsh_class exc_finish_read_handler_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_exc_finish_read_handler_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct exc_finish_read_handler *i = (struct exc_finish_read_handler *) o;
  mark((struct lsh_object *) i->fd);
}

struct lsh_class exc_finish_read_handler_class =
{ STATIC_HEADER,
  &exception_handler_class, "exc_finish_read_handler", sizeof(struct exc_finish_read_handler),
  do_exc_finish_read_handler_mark,
  NULL
};
#endif /* !GABA_DECLARE */

