#ifndef GABA_DEFINE
struct proxy_channel
{
  struct ssh_channel super;
  struct proxy_channel *chain;
  void (*(init_io))(struct proxy_channel *self, struct proxy_channel *chain);
};
extern struct lsh_class proxy_channel_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_proxy_channel_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct proxy_channel *i = (struct proxy_channel *) o;
  mark((struct lsh_object *) i->chain);
}

struct lsh_class proxy_channel_class =
{ STATIC_HEADER,
  &ssh_channel_class, "proxy_channel", sizeof(struct proxy_channel),
  do_proxy_channel_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct proxy_channel_open_continuation
{
  struct command_continuation super;
  struct command_continuation *up;
  struct proxy_channel *channel;
};
extern struct lsh_class proxy_channel_open_continuation_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_proxy_channel_open_continuation_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct proxy_channel_open_continuation *i = (struct proxy_channel_open_continuation *) o;
  mark((struct lsh_object *) i->up);
  mark((struct lsh_object *) i->channel);
}

struct lsh_class proxy_channel_open_continuation_class =
{ STATIC_HEADER,
  &command_continuation_class, "proxy_channel_open_continuation", sizeof(struct proxy_channel_open_continuation),
  do_proxy_channel_open_continuation_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct proxy_channel_open_command
{
  struct channel_open_command super;
  UINT32 type;
  struct alist *requests;
};
extern struct lsh_class proxy_channel_open_command_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_proxy_channel_open_command_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct proxy_channel_open_command *i = (struct proxy_channel_open_command *) o;
  mark((struct lsh_object *) i->requests);
}

struct lsh_class proxy_channel_open_command_class =
{ STATIC_HEADER,
  &channel_open_command_class, "proxy_channel_open_command", sizeof(struct proxy_channel_open_command),
  do_proxy_channel_open_command_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct proxy_open_session
{
  struct channel_open super;
  struct alist *server_requests;
  struct alist *client_requests;
};
extern struct lsh_class proxy_open_session_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_proxy_open_session_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct proxy_open_session *i = (struct proxy_open_session *) o;
  mark((struct lsh_object *) i->server_requests);
  mark((struct lsh_object *) i->client_requests);
}

struct lsh_class proxy_open_session_class =
{ STATIC_HEADER,
  &channel_open_class, "proxy_open_session", sizeof(struct proxy_open_session),
  do_proxy_open_session_mark,
  NULL
};
#endif /* !GABA_DECLARE */

