/*  *********************************************************************
    File: sslutil.c

    SSLRef 3.0 Final -- 11/19/96

    Copyright (c)1996 by Netscape Communications Corp.

    By retrieving this software you are bound by the licensing terms
    disclosed in the file "LICENSE.txt". Please read it, and if you don't
    accept the terms, delete this software.

    SSLRef 3.0 was developed by Netscape Communications Corp. of Mountain
    View, California <http://home.netscape.com/> and Consensus Development
    Corporation of Berkeley, California <http://www.consensus.com/>.

    *********************************************************************

    File: sslutil.c    Utility functions for encoding structures

    Handles encoding endian-independant wire representation of 2, 3, or 4
    byte integers.

    ****************************************************************** */

#ifndef _SSL_H_
#include "sslutil.h"
#endif

uint32
SSLDecodeInt(unsigned char *p, int length)
{   uint32  val = 0;
    while (length--)
        val = (val << 8) | *p++;
    return val;
}

unsigned char *
SSLEncodeInt(unsigned char *p, uint32 value, int length)
{   unsigned char   *retVal = p + length;       /* Return pointer to char after int */
    ASSERT(length > 0 && length <= 4);
    while (length--)                /* Assemble backwards */
    {   p[length] = (uint8)value;   /* Implicit masking to low byte */
        value >>= 8;
    }
    return retVal;
}

void
IncrementUInt64(uint64 *v)
{   if (++v->low == 0)          /* Must have just rolled over */
        ++v->high;
}
