/*  *********************************************************************
    File: sslrc4.c

    SSLRef 3.0 Final -- 11/19/96

    Copyright (c)1996 by Netscape Communications Corp.

    By retrieving this software you are bound by the licensing terms
    disclosed in the file "LICENSE.txt". Please read it, and if you don't
    accept the terms, delete this software.

    SSLRef 3.0 was developed by Netscape Communications Corp. of Mountain
    View, California <http://home.netscape.com/> and Consensus Development
    Corporation of Berkeley, California <http://www.consensus.com/>.

    *********************************************************************

    File: sslrc4.c


    ****************************************************************** */

#ifndef _SSL_H_
#include "ssl.h"
#endif

#ifndef _CRYPTYPE_H_
#include "cryptype.h"
#endif

#ifndef _SSLALLOC_H_
#include "sslalloc.h"
#endif

#ifndef _SSLCTX_H_
#include "sslctx.h"
#endif

#include <string.h>

#if BSAFE || HAS_RSAREF_RC4

SSLErr RC4Init(uint8 *key, uint8 *iv, void **cipherRef, SSLContext *ctx);
SSLErr RC4Transform(SSLBuffer src, SSLBuffer dest, void *cipherRef, SSLContext *ctx);
SSLErr RC4Finish(void *cipherRef, SSLContext *ctx);

SSLSymmetricCipher SSLCipherRC4_40 = {
    16,         /* Key size in bytes */
    5,          /* Secret key size = 40 bits */
    0,          /* IV size */
    0,          /* Block size */
    RC4Init,
    RC4Transform,
    RC4Transform,
    RC4Finish
};

SSLSymmetricCipher SSLCipherRC4_128 = {
    16,         /* Key size in bytes */
    16,         /* Secret key size = 40 bits */
    0,          /* IV size */
    0,          /* Block size */
    RC4Init,
    RC4Transform,
    RC4Transform,
    RC4Finish
};
#endif

#if BSAFE
SSLErr
RC4Init(uint8 *key, uint8* iv, void **cipherRef, SSLContext *ctx)
{   SSLBuffer                   rc4State;
    B_ALGORITHM_OBJ             *rc4;
    static B_ALGORITHM_METHOD   *chooser[] = { &AM_RC4_ENCRYPT, &AM_RC4_DECRYPT, 0 };
    B_KEY_OBJ                   rc4Key;
    ITEM                        keyData;
    SSLErr                      err;
    int                         rsaErr;

    if ((err = SSLAllocBuffer(&rc4State, sizeof(B_ALGORITHM_OBJ), &ctx->sysCtx)) != 0)
        return err;
    rc4 = (B_ALGORITHM_OBJ*)rc4State.data;
    if ((rsaErr = B_CreateAlgorithmObject(rc4)) != 0)
        return SSLUnknownErr;
    if ((rsaErr = B_SetAlgorithmInfo(*rc4, AI_RC4, 0)) != 0)
        return SSLUnknownErr;
    if ((rsaErr = B_CreateKeyObject(&rc4Key)) != 0)
        return SSLUnknownErr;
    keyData.data = key;
    keyData.len = 16;
    if ((rsaErr = B_SetKeyInfo(rc4Key, KI_Item, (POINTER) &keyData)) != 0)
    {   B_DestroyKeyObject(&rc4Key);
        return SSLUnknownErr;
    }
    if ((rsaErr = B_EncryptInit(*rc4, rc4Key, chooser, NO_SURR)) != 0)
    {   B_DestroyKeyObject(&rc4Key);
        return SSLUnknownErr;
    }
    B_DestroyKeyObject(&rc4Key);
    
    *cipherRef = (void*)rc4State.data;
    return SSLNoErr;
}

/* For RC4, encrytion = decryption, so use the same function for both */
SSLErr
RC4Transform(SSLBuffer src, SSLBuffer dest, void *cipherRef, SSLContext *ctx)
{   B_ALGORITHM_OBJ     *rc4 = (B_ALGORITHM_OBJ*)cipherRef;
    int                 rsaErr;
    unsigned int        outputLen;
    
    ASSERT(src.length == dest.length);
    
    if ((rsaErr = B_EncryptUpdate(*rc4, dest.data, &outputLen, dest.length, src.data, src.length,
                    (B_ALGORITHM_OBJ) 0, NO_SURR)) != 0)
        return SSLUnknownErr;
    
    ASSERT(outputLen == src.length);
    
    if (outputLen != src.length)
        return SSLUnknownErr;
    
    return SSLNoErr;
}

SSLErr
RC4Finish(void *cipherRef, SSLContext *ctx)
{   B_ALGORITHM_OBJ     *rc4 = (B_ALGORITHM_OBJ*)cipherRef;
    SSLBuffer           rc4State;
    SSLErr              err;
    
    B_DestroyAlgorithmObject(rc4);
    rc4State.data = (unsigned char*)cipherRef;
    rc4State.length = sizeof(B_ALGORITHM_OBJ);
    err = SSLFreeBuffer(&rc4State, &ctx->sysCtx);
    return err;
}
#endif /* BSAFE */

/* Unfortunately, RSAREF does not include an RC4 implementation.
 *  We cannot include an implementation with this reference implementation.
 *  However, we include the following functions to illustrate how
 *  such an implementation might be integrated into the library.
 */

#if HAS_RSAREF_RC4

#include "rc4.h"

SSLErr
RC4Init(uint8 *key, uint8* iv, void **cipherRef, SSLContext *ctx)
{   SSLBuffer   rc4State;
    SSLErr      err;
    
    if ((err = SSLAllocBuffer(&rc4State, sizeof(rc4_key), &ctx->sysCtx)) != 0)
        return err;
    prepare_key(key, 16, (rc4_key*)rc4State.data);
    *cipherRef = (void*)rc4State.data;
    return SSLNoErr;
}

/* For RC4, encrytion = decryption, so use the same function for both */
SSLErr
RC4Transform(SSLBuffer src, SSLBuffer dest, void *cipherRef, SSLContext *ctx)
{   ASSERT(src.length == dest.length);
    
/* If we're not encrypting in place, copy the data first, because we only encrypt in place */
    if (src.data != dest.data)
        memcpy(dest.data, src.data, src.length);
    rc4(dest.data, dest.length, (rc4_key*)cipherRef);
    return SSLNoErr;
}

SSLErr
RC4Finish(void *cipherRef, SSLContext *ctx)
{   SSLBuffer   rc4State;
    SSLErr      err;
    
    rc4State.data = (unsigned char*)cipherRef;
    rc4State.length = sizeof(rc4_key);
    err = SSLFreeBuffer(&rc4State, &ctx->sysCtx);
    return err;
}
#endif
