/*  *********************************************************************
    File: ssldebug.c

    SSLRef 3.0 Final -- 11/19/96

    Copyright (c)1996 by Netscape Communications Corp.

    By retrieving this software you are bound by the licensing terms
    disclosed in the file "LICENSE.txt". Please read it, and if you don't
    accept the terms, delete this software.

    SSLRef 3.0 was developed by Netscape Communications Corp. of Mountain
    View, California <http://home.netscape.com/> and Consensus Development
    Corporation of Berkeley, California <http://www.consensus.com/>.

    *********************************************************************

    File: ssldebug.c   Debug utilities

    Simple message printing and data dumping functions for use when the
    DEBUG macro is non-zero.

    ****************************************************************** */

#ifndef _SSL_H_
#include "ssl.h"
#endif /* _SSL_H_ */

#include <stdio.h>

static FILE*    DebugDest = stdout;

static void DebugDumpData(void *data, uint32 length, int spacing);

void
AssertMessage(char *message, char *file, int line)
{   
    fprintf(DebugDest, "File %s; Line %d # %s\n", file, line, message);
}

void
DebugMessage(char *message, char *file, int line)
{   
    fprintf(DebugDest, "File %s; Line %d # %s\n", file, line, message);
}

void
DebugValMessage(char *message, char *file, int line, uint32 v1, uint32 v2, uint32 v3, uint32 v4)
{   fprintf(DebugDest, "File %s; Line %d # ", file, line);
    fprintf(DebugDest, message, v1, v2, v3, v4);
    fprintf(DebugDest, "\n");
}

void
DebugDumpDataValue(char *message, uint32 value, void *data, uint32 length)
{   int     spacing;
    
    spacing = fprintf(DebugDest, "%s %08X:  ", message, value);
    DebugDumpData(data, length, spacing);
}

void
DebugDumpDataName(char *name, void *data, uint32 length)
{   int     spacing;
    
    spacing = fprintf(DebugDest, "%s:  ", name);
    DebugDumpData(data, length, spacing);
}

static void
DebugDumpData(void *data, uint32 length, int spacing)
{   unsigned char   *p;
    uint32          i;
    
    p = data;
    for (i = 0; i < length; i++)
    {   if (i > 0 && i % 16 == 0)
            fprintf(DebugDest, "\n%*s",spacing,"");
        fprintf(DebugDest, "%02X ", *p++);
    }
    fprintf(DebugDest, "\n");
}

#define NONFATAL(err)       {   err, 0      }
#define ERROR_ENTRY(err)    {   err, #err   }
typedef struct
{   SSLErr  err;
    char    *name;
} ErrorName;

static ErrorName ErrorNames[] =
{   NONFATAL(SSLNoErr),
    NONFATAL(SSLWouldBlockErr),
    NONFATAL(SSLConnectionClosedGraceful),
    NONFATAL(SSLSessionNotFoundErr),
    ERROR_ENTRY(SSLMemoryErr),
    ERROR_ENTRY(SSLUnsupportedErr),
    ERROR_ENTRY(SSLOverflowErr),
    ERROR_ENTRY(SSLUnknownErr),
    ERROR_ENTRY(SSLProtocolErr),
    ERROR_ENTRY(SSLNegotiationErr),
    ERROR_ENTRY(SSLFatalAlert),
    ERROR_ENTRY(SSLIOErr),
    ERROR_ENTRY(SSLConnectionClosedError),
    ERROR_ENTRY(ASNBadEncodingErr),
    ERROR_ENTRY(ASNIntegerTooBigErr),
    ERROR_ENTRY(X509CertChainInvalidErr),
    ERROR_ENTRY(X509NamesNotEqualErr)
};

SSLErr
DebugError(SSLErr err, char *file, int line)
{   int         i;
    
    for (i = 0; i < sizeof(ErrorNames)/sizeof(ErrorName); i++)
        if (err == ErrorNames[i].err)
        {   if (ErrorNames[i].name != 0)
                fprintf(DebugDest, "File %s; Line %d # Error %d [%s]\n", file, line, err, ErrorNames[i].name);
            return err;
        }
    
    fprintf(DebugDest, "File %s; Line %d # Error %d [????] returned\n", file, line, err);
    return err;
}
