/*  *********************************************************************
    File: sslalloc.c

    SSLRef 3.0 Final -- 11/19/96

    Copyright (c)1996 by Netscape Communications Corp.

    By retrieving this software you are bound by the licensing terms
    disclosed in the file "LICENSE.txt". Please read it, and if you don't
    accept the terms, delete this software.

    SSLRef 3.0 was developed by Netscape Communications Corp. of Mountain
    View, California <http://home.netscape.com/> and Consensus Development
    Corporation of Berkeley, California <http://www.consensus.com/>.

    *********************************************************************

    File: sslalloc.c   Utility functions for doing allocation

    These functions call the user-supplied callbacks to
    allocate/free/reallocate memory

    ****************************************************************** */

#ifndef _SSLALLOC_H_
#include "sslalloc.h"
#endif

#ifndef _SSLCTX_H_
#include "sslctx.h"
#endif

SSLErr
SSLAllocBuffer(SSLBuffer *buf, uint32 length, SystemContext *ctx)
{   buf->data = 0;
    buf->length = length;
    return ctx->alloc(buf, ctx->allocRef);
}

SSLErr
SSLFreeBuffer(SSLBuffer *buf, SystemContext *ctx)
{   SSLErr      err = SSLNoErr;
    if (buf->data != 0)
    {   err = ctx->free(buf, ctx->allocRef);
        buf->data = 0;
    }
    return err;
}

SSLErr
SSLReallocBuffer(SSLBuffer *buf, uint32 newSize, SystemContext *ctx)
{   return ctx->realloc(buf, newSize, ctx->allocRef);
}

