/*  *********************************************************************
    File: ssl2map.c

    SSLRef 3.0 Final -- 11/19/96

    Copyright (c)1996 by Netscape Communications Corp.

    By retrieving this software you are bound by the licensing terms
    disclosed in the file "LICENSE.txt". Please read it, and if you don't
    accept the terms, delete this software.

    SSLRef 3.0 was developed by Netscape Communications Corp. of Mountain
    View, California <http://home.netscape.com/> and Consensus Development
    Corporation of Berkeley, California <http://www.consensus.com/>.

    *********************************************************************

    File: ssl2map.c    Maps SSL 2 cipher kinds to SSL 3 cipher suites

    We use the SSL 3 CipherSuites to look up ciphers, hashes, etc; thus,
    this table maps two-byte SSL 3 CipherSuite values to three-byte SSL 2
    CipherKind values.

    ****************************************************************** */

#ifndef _CRYPTYPE_H_
#include "cryptype.h"
#endif

SSLCipherMapping SSL2CipherMap[] =
{   {   SSL2_RC4_128_WITH_MD5, SSL_RSA_WITH_RC4_128_MD5 },
    {   SSL2_RC4_128_EXPORT_40_WITH_MD5, SSL_RSA_EXPORT_WITH_RC4_40_MD5 },
    {   SSL2_RC2_128_CBC_WITH_MD5, SSL_RSA_WITH_RC2_CBC_MD5 },
    {   SSL2_RC2_128_CBC_EXPORT40_WITH_MD5, SSL_RSA_EXPORT_WITH_RC2_CBC_40_MD5 },
    {   SSL2_IDEA_128_CBC_WITH_MD5, SSL_RSA_WITH_IDEA_CBC_MD5 },
    {   SSL2_DES_64_CBC_WITH_MD5, SSL_RSA_WITH_DES_CBC_MD5 },
    {   SSL2_DES_192_EDE3_CBC_WITH_MD5, SSL_RSA_WITH_3DES_EDE_CBC_MD5}
};

int SSL2CipherMapCount = sizeof(SSL2CipherMap) / sizeof(SSLCipherMapping);
