/*  *********************************************************************
    File: nullciph.c

    SSLRef 3.0 Final -- 11/19/96

    Copyright (c)1996 by Netscape Communications Corp.

    By retrieving this software you are bound by the licensing terms
    disclosed in the file "LICENSE.txt". Please read it, and if you don't
    accept the terms, delete this software.

    SSLRef 3.0 was developed by Netscape Communications Corp. of Mountain
    View, California <http://home.netscape.com/> and Consensus Development
    Corporation of Berkeley, California <http://www.consensus.com/>.

    *********************************************************************

    File: nullciph.c   A dummy implementation of the null cipher

    The null cipher is used for SSL_NULL_WITH_NULL_NULL,
    SSL_RSA_WITH_NULL_MD5, and SSL_RSA_WITH_NULL_SHA ciphers.

    ****************************************************************** */

#ifndef _CRYPTYPE_H_
#include "cryptype.h"
#endif

#ifndef _SSLCTX_H_
#include "sslctx.h"
#endif

#include <string.h>

SSLErr NullInit(uint8 *key, uint8* iv, void **cipherRef, SSLContext *ctx);
SSLErr NullCrypt(SSLBuffer src, SSLBuffer dest, void *, SSLContext *);
SSLErr NullFinish(void *, SSLContext *);

SSLSymmetricCipher SSLCipherNull = {
    0,          /* Key size in bytes (ignoring parity) */
    0,          /* Secret key size */
    0,          /* IV size */
    0,          /* Block size */
    NullInit,
    NullCrypt,
    NullCrypt,
    NullFinish
};

SSLErr
NullInit(uint8 *key, uint8* iv, void **cipherRef, SSLContext *ctx)
{   return SSLNoErr;
}

SSLErr
NullCrypt(SSLBuffer src, SSLBuffer dest, void *cipherRef, SSLContext *ctx)
{   if (src.data != dest.data)
        memcpy(dest.data, src.data, src.length);
    return SSLNoErr;
}

SSLErr
NullFinish(void *cipherRef, SSLContext *ctx)
{   return SSLNoErr;
}
