/*  *********************************************************************
    File: hdskchgc.c

    SSLRef 3.0 Final -- 11/19/96

    Copyright (c)1996 by Netscape Communications Corp.

    By retrieving this software you are bound by the licensing terms
    disclosed in the file "LICENSE.txt". Please read it, and if you don't
    accept the terms, delete this software.

    SSLRef 3.0 was developed by Netscape Communications Corp. of Mountain
    View, California <http://home.netscape.com/> and Consensus Development
    Corporation of Berkeley, California <http://www.consensus.com/>.

    *********************************************************************

    File: hdskchgc.c   Contains support for change cipher spec messages

    Simple support for encoding and decoding change cipher spec messages;
    the decode message also installs the pending read cipher (if it is
    ready).

    ****************************************************************** */

#ifndef _SSLCTX_H_
#include "sslctx.h"
#endif

#ifndef _SSLHDSHK_H_
#include "sslhdshk.h"
#endif

#ifndef _SSLALLOC_H_
#include "sslalloc.h"
#endif

#ifndef _SSLALERT_H_
#include "sslalert.h"
#endif

#include <string.h>

SSLErr
SSLEncodeChangeCipherSpec(SSLRecord *rec, SSLContext *ctx)
{   SSLErr          err;
    
    ASSERT(ctx->writePending.ready);
    
    rec->contentType = SSL_change_cipher_spec;
    rec->protocolVersion = SSL_Version_3_0;
    rec->contents.length = 1;
    if ((err = SSLAllocBuffer(&rec->contents, 1, &ctx->sysCtx)) != 0)
        return err;
    rec->contents.data[0] = 1;
    
    return SSLNoErr;
}

SSLErr
SSLProcessChangeCipherSpec(SSLRecord rec, SSLContext *ctx)
{   SSLErr          err;
    
    if (rec.contents.length != 1 || rec.contents.data[0] != 1)
    {   SSLFatalSessionAlert(alert_unexpected_message, ctx);
        return SSLProtocolErr;
    }
    
    if (!ctx->readPending.ready || ctx->state != HandshakeChangeCipherSpec)
    {   SSLFatalSessionAlert(alert_unexpected_message, ctx);
        return SSLProtocolErr;
    }
    
    /* Install new cipher spec on read side */
    if ((err = SSLDisposeCipherSuite(&ctx->readCipher, ctx)) != 0)
    {   SSLFatalSessionAlert(alert_close_notify, ctx);
        return err;
    }
    ctx->readCipher = ctx->readPending;
    ctx->readCipher.ready = 0;      /* Can't send data until Finished is sent */
    ctx->state = HandshakeFinished;
    memset(&ctx->readPending, 0, sizeof(CipherContext));        /* Zero out old data */
    return SSLNoErr;    
}

SSLErr
SSLDisposeCipherSuite(CipherContext *cipher, SSLContext *ctx)
{   SSLErr      err;
    
    if (cipher->symCipherState)
    {   if ((err = cipher->symCipher->finish(cipher->symCipherState, ctx)) != 0)
            return err;
        cipher->symCipherState = 0;
    }
    
    return SSLNoErr;
}
