/*  *********************************************************************
    File: asn1oids.c

    SSLRef 3.0 Final -- 11/19/96

    Copyright (c)1996 by Netscape Communications Corp.

    By retrieving this software you are bound by the licensing terms
    disclosed in the file "LICENSE.txt". Please read it, and if you don't
    accept the terms, delete this software.

    SSLRef 3.0 was developed by Netscape Communications Corp. of Mountain
    View, California <http://home.netscape.com/> and Consensus Development
    Corporation of Berkeley, California <http://www.consensus.com/>.

    *********************************************************************

    File: asn1oids.c   A table of ASN.1 object IDs

    Maps DER-encoded ASN.1 object IDs to enumerated values, allowing them
    to be compared more easily.

    ****************************************************************** */

#ifndef _ASN1TYPE_H_
#include "asn1type.h"
#endif

#ifndef _ASN1OIDS_H_
#include "asn1oids.h"
#endif

/* Data definitions of all our favorite object IDs */
#define PKCS    42, 134, 72, 134, 247, 13, 1

static uint8    RSAEncryption[] = { PKCS, 1, 1 },
                MD2WithRSA[] = { PKCS, 1, 2 },
                MD4WithRSA[] = { PKCS, 1, 3 },
                MD5WithRSA[] = { PKCS, 1, 4 },
                DKKeyAgreement[] = { PKCS, 3, 1 },
                PBEWithMD2AndDES_CBC[] = { PKCS, 5, 1 },
                PBEWithMD5AndDES_CBC[] = { PKCS, 5, 3 },
                EmailAddress[] = { PKCS, 9, 1 },
                UnstructuredName[] = { PKCS, 9, 2 },
                ContentType[] = { PKCS, 9, 3 },
                MessageDigest[] = { PKCS, 9, 4 },
                SigningTime[] = { PKCS, 9, 5 },
                CounterSignature[] = { PKCS, 9, 6 },
                ChallengePassword[] = { PKCS, 9, 7 },
                UnstructuredAddress[] = { PKCS, 9, 8 },
                ExtendedCertificateAttributes[] = { PKCS, 9, 9 };

#define X520    85, 4

static uint8    ObjectClass[] = { X520, 0 },
                AliasedObjectName[] = { X520, 1 },
                KnowledgeInformation[] = { X520, 2 },
                CommonName[] = { X520, 3 },
                SurName[] = { X520, 4 },
                SerialNumber[] = { X520, 5 },
                CountryName[] = { X520, 6 },
                LocalityName[] = { X520, 7 },
                StateProvinceName[] = { X520, 8 },
                StreetAddress[] = { X520, 9 },
                OrganizationName[] = { X520, 10 },
                OrganizationalUnitName[] = { X520, 11 },
                Title[] = { X520, 12 },
                Description[] = { X520, 13 },
                SearchGuide[] = { X520, 14 },
                BusinessCategory[] = { X520, 15 },
                PostalAddress[] = { X520, 16 },
                PostalCode[] = { X520, 17 },
                PostOfficeBox[] = { X520, 18 },
                PhysicalDeliveryOfficeName[] = { X520, 19 },
                TelephoneNumber[] = { X520, 20 },
                TelexNumber[] = { X520, 21 },
                TelexTerminalIdentifier[] = { X520, 22 },
                FacsimileTelephoneNumber[] = { X520, 23 },
                X_121Address[] = { X520, 24 },
                InternationalISDNNumber[] = { X520, 25 },
                RegisteredAddress[] = { X520, 26 },
                DestinationIndicator[] = { X520, 27 },
                PreferredDeliveryMethod[] = { X520, 28 },
                PresentationAddress[] = { X520, 29 },
                SupportedApplicationContext[] = { X520, 30 },
                Member[] = { X520, 31 },
                Owner[] = { X520, 32 },
                RoleOccupant[] = { X520, 33 },
                SeeAlso[] = { X520, 34 },
                UserPassword[] = { X520, 35 },
                UserCertificate[] = { X520, 36 },
                CACertificate[] = { X520, 37 },
                AuthorityRevocationList[] = { X520, 38 },
                CertificateRevocationList[] = { X520, 39 },
                CrossCertificatePair[] = { X520, 40 };

/* ASNKnownObjectIDs is an array that maps object ID BER representations
    to more easily dealt-with integer IDs. The ID zero maps to no match,
    and so must always be last in the table.
*/

#define OIDDEF(tag, arrayName)  { tag, { sizeof(arrayName), arrayName } }

ASN1ObjectID ASNKnownObjectIDs[] =
{   OIDDEF( OID_rsaEncryption, RSAEncryption ),
    OIDDEF( OID_md2WithRSA, MD2WithRSA ),
    OIDDEF( OID_md4WithRSA, MD4WithRSA ),
    OIDDEF( OID_md5WithRSA, MD5WithRSA ),
    OIDDEF( OID_dhKeyAgreement, DKKeyAgreement ),
    OIDDEF( OID_pbeWithMD2AndDES_CBC, PBEWithMD2AndDES_CBC ),
    OIDDEF( OID_pbeWithMD5AndDES_CBC, PBEWithMD5AndDES_CBC ),
    OIDDEF( OID_emailAddress,EmailAddress ),
    OIDDEF( OID_unstructuredName, UnstructuredName ),
    OIDDEF( OID_contentType, ContentType ),
    OIDDEF( OID_messageDigest, MessageDigest ),
    OIDDEF( OID_signingTime, SigningTime ),
    OIDDEF( OID_counterSignature, CounterSignature ),
    OIDDEF( OID_challengePassword, ChallengePassword ),
    OIDDEF( OID_unstructuredAddress, UnstructuredAddress ),
    OIDDEF( OID_extendedCertificateAttributes, ExtendedCertificateAttributes),
    OIDDEF( OID_commonName, CommonName ),
    OIDDEF( OID_surName, SurName ),
    OIDDEF( OID_serialNumber, SerialNumber ),
    OIDDEF( OID_countryName, CountryName ),
    OIDDEF( OID_localityName, LocalityName ),
    OIDDEF( OID_stateProvinceName, StateProvinceName ),
    OIDDEF( OID_streetAddress, StreetAddress ),
    OIDDEF( OID_organizationName, OrganizationName ),
    OIDDEF( OID_organizationalUnitName, OrganizationalUnitName ),
    OIDDEF( OID_title, Title ),
    OIDDEF( OID_description, Description ),
    OIDDEF( OID_businessCategory, BusinessCategory ),
    OIDDEF( OID_postalAddress, PostalAddress ),
    OIDDEF( OID_postalCode, PostalCode ),
    OIDDEF( OID_postOfficeBox, PostOfficeBox ),
    OIDDEF( OID_physicalDeliveryOfficeName, PhysicalDeliveryOfficeName ),
    OIDDEF( OID_telephoneNumber, TelephoneNumber ),
    OIDDEF( OID_telexNumber, TelexNumber ),
    OIDDEF( OID_telexTerminalIdentifier, TelexTerminalIdentifier ),
    OIDDEF( OID_facsimileTelephoneNumber, FacsimileTelephoneNumber ),
    OIDDEF( OID_x_121Address, X_121Address ),
    OIDDEF( OID_internationalISDNNumber, InternationalISDNNumber ),
    OIDDEF( OID_registeredAddress, RegisteredAddress ),
    OIDDEF( OID_destinationIndicator, DestinationIndicator ),
    OIDDEF( OID_preferredDeliveryMethod, PreferredDeliveryMethod ),
    OIDDEF( OID_presentationAddress, PresentationAddress ),
    OIDDEF( OID_supportedApplicationContext, SupportedApplicationContext ),
    OIDDEF( OID_member, Member ),
    OIDDEF( OID_owner, Owner ),
    OIDDEF( OID_roleOccupant, RoleOccupant ),
    { OID_noMatch, { 0, 0 } }
};

