/*
   VERISIGN, INC. LICENSE AGREEMENT

  IMPORTANT - READ CAREFULLY BEFORE DOWNLOADING OR INSTALLING

  This file lists the VeriSign, Inc. ("VeriSign") Class 1 Certification
  Authority Distinguished Name and Public Key information (the "Information").
  BY DOWNLOADING OR INSTALLING THE INFORMATION, YOU INDICATE YOUR ACCEPTANCE
  OF THIS LICENSE.  IF YOU DO NOT AGREE TO ALL OF THE TERMS OF THIS LICENSE,
  DO NOT DOWNLOAD OR USE THE INFORMATION.

  1.   License and Limitations.  VeriSign grants you a royalty-free license to
  use, copy and distribute the Information or any compiled derivative of it,
  subject to the terms of this License.  You must reproduce and include this
  entire License and VeriSign's copyright notices and trademarks on each copy
  of the Information and compiled derivative of it.  VeriSign retains all
  ownership of the Information and all intellectual property rights therein.

  2.   No Warranty.  VeriSign provides the Information "AS IS" and makes no
  warranties, expressed or implied, about the Information or the use thereof.
  WITHOUT LIMITATION, VERISIGN DISCLAIMS ANY IMPLIED WARRANTIES OF
  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT OF
  THIRD PARTY RIGHTS.

  3.   Limitation of Liability.  VeriSign's entire liability to you under this
  License shall be limited to a maximum of $10.00.  IN NO EVENT SHALL VERISIGN
  BE LIABLE TO YOU OR TO ANY OTHER PERSON FOR ANY SPECIAL, INCIDENTAL OR
  CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE THE
  INFORMATION.

  4.   General.  This License is governed by the laws of the State of California
  and is the complete and exclusive statement of your agreement with VeriSign
  with respect to the Information.  You acknowledge that the Information is
  being provided to you without charge and that this is reflected in the
  absence of warranties and limitations of liability in this License.

  5.   NOTICE: THE USE OF THIS VERISIGN CERTIFICATE IS SUBJECT TO THE
  VERISIGN CERTIFICATION PRACTICE STATEMENT LOCATED AT
       http://www.verisign.com/repository/CPS
  OR AVAILABLE FROM:
     VeriSign, Inc.
     2593 Coast Ave.
     Mountain View, CA 94043
     (415) 961-7500

  Code Fragments and ASN.1 discussion are taken from the PKCS standards
  published by RSA Data Security, Inc.

  Copyright 1995 VeriSign, Inc. All Rights Reserved.
*/


/* VeriSign Class 1 Root Subject Name (BER Encoded)

  This section gives the ASN.1 notation for the X.501 type
  Name.

  Name ::= CHOICE {
              RDNSequence }

   RDNSequence ::= SEQUENCE OF RelativeDistinguishedName

   RelativeDistinguishedName ::=
     SET OF AttributeValueAssertion

   AttributeValueAssertion ::= SEQUENCE {
      AttributeType,
      AttributeValue }

   AttributeType ::= OBJECT IDENTIFIER

   AttributeValue ::= ANY

   The Name type identifies an object in an X.500 directory.  Name is
   a CHOICE type consisting of one alternative: RDNSequence. (Future
   revisions of X.500 may have other alternatives.)

   The RDNSequence type gives a path through an X.500 directory tree
   starting at the root. RDNSequence is a SEQUENCE OF type consisting
   of zero or more occurences of RelativeDistinguishedName.

   The RelativeDistinguishedName type gives a unique name to an object
   relative to the object superior to it in the directory
   tree. RelativeDistinguishedName is a SET OF type consisting of zero
   or more occurrences of AttributeValueAssertion.

   The AttributeValueAssertion type assigns a value to some attribute
   of a relative distinguished name, such as country name or common
   name. AttributeValueAssertion is a SEQUENCE type consisting of two
   components, an AttributeType type and an AttributeValue type.

   The AttributeType type identifies an attribute by object
   identifier. The AttributeValue type gives an arbitrary attribute
   value. The actual type of the attribute value is determined by the
   attribute type.

   The specific ASN.1 value encoded below represents the following
   name:
      Country = US
      Organization = VeriSign, Inc.
      Organizational Unit = Class 1 Public Primary Certification Authority

   Using the TIPEM toolkit the following string would be used to initilize a
   name object:

   if ((status = SetNameBER
              (class1RootSubjectName, CLASS1_ROOT_SUBJECT_NAME, sizeof (CLASS1_ROOT_SUBJECT_NAME), (ERROR_CTX *)NULL_PTR)) != 0)
     break;
 */

unsigned char CLASS1_ROOT_SUBJECT_NAME[97] = {
 0x30, 0x5f, 0x31, 0x0b, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 0x55, 0x53, 0x31,
 0x17, 0x30, 0x15, 0x06, 0x03, 0x55, 0x04, 0x0a, 0x13, 0x0e, 0x56, 0x65, 0x72, 0x69, 0x53, 0x69,
 0x67, 0x6e, 0x2c, 0x20, 0x49, 0x6e, 0x63, 0x2e, 0x31, 0x37, 0x30, 0x35, 0x06, 0x03, 0x55, 0x04,
 0x0b, 0x13, 0x2e, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x20, 0x31, 0x20, 0x50, 0x75, 0x62, 0x6c, 0x69,
 0x63, 0x20, 0x50, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x20, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66,
 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74,
 0x79
};


/* VeriSign Class 1 Root Subject Public Key

   subjectPublicKeyInfo contains information about the public key
   being certified. The information identifies the entity's public-key
   algorithm (and any associated parameters); examples of public-key
   algorithms include X.509's rsa and PKCS #1's rsaEncryption. The
   information also includes a bit- string representation of the
   entity's public key.  For both public-key algorithms just
   mentioned, the bit string contains the BER encoding of a value of
   X.509/PKCS #1 type RSAPublicKey.

   SubjectPublicKeyInfo ::= SEQUENCE {
     algorithm AlgorithmIdentifier,
     subjectPublicKey BIT STRING }

   AlgorithmIdentifier ::= SEQUENCE {
     algorithm OBJECT IDENTIFIER,
     parameters ANY DEFINED BY ALGORITHM OPTIONAL }

   The name and subject public key contained below may be added to a TIPEM
   root list using the following function:

   if (status = AddMeRoot
       (&class1MeIndex, meSet, CLASS1_ROOT_SUBJECT_NAME, sizeof (CLASS1_ROOT_SUBJECT_NAME), 
        CLASS1_ROOT_SUBJECT_PUBLIC_KEY, sizeof (CLASS1_ROOT_SUBJECT_PUBLIC_KEY)))
     break;
 */

unsigned char CLASS1_ROOT_SUBJECT_PUBLIC_KEY[165] = {
 0x30, 0x81, 0x9f, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x01,
 0x05, 0x00, 0x03, 0x81, 0x8d, 0x00, 0x30, 0x81, 0x89, 0x02, 0x81, 0x81, 0x00, 0xe5, 0x19, 0xbf,
 0x6d, 0xa3, 0x56, 0x61, 0x2d, 0x99, 0x48, 0x71, 0xf6, 0x67, 0xde, 0xb9, 0x8d, 0xeb, 0xb7, 0x9e,
 0x86, 0x80, 0x0a, 0x91, 0x0e, 0xfa, 0x38, 0x25, 0xaf, 0x46, 0x88, 0x82, 0xe5, 0x73, 0xa8, 0xa0,
 0x9b, 0x24, 0x5d, 0x0d, 0x1f, 0xcc, 0x65, 0x6e, 0x0c, 0xb0, 0xd0, 0x56, 0x84, 0x18, 0x87, 0x9a,
 0x06, 0x9b, 0x10, 0xa1, 0x73, 0xdf, 0xb4, 0x58, 0x39, 0x6b, 0x6e, 0xc1, 0xf6, 0x15, 0xd5, 0xa8,
 0xa8, 0x3f, 0xaa, 0x12, 0x06, 0x8d, 0x31, 0xac, 0x7f, 0xb0, 0x34, 0xd7, 0x8f, 0x34, 0x67, 0x88,
 0x09, 0xcd, 0x14, 0x11, 0xe2, 0x4e, 0x45, 0x56, 0x69, 0x1f, 0x78, 0x02, 0x80, 0xda, 0xdc, 0x47,
 0x91, 0x29, 0xbb, 0x36, 0xc9, 0x63, 0x5c, 0xc5, 0xe0, 0xd7, 0x2d, 0x87, 0x7b, 0xa1, 0xb7, 0x32,
 0xb0, 0x7b, 0x30, 0xba, 0x2a, 0x2f, 0x31, 0xaa, 0xee, 0xa3, 0x67, 0xda, 0xdb, 0x02, 0x03, 0x01,
 0x00, 0x01
};

/* VeriSign Class 1 Root Self-Signed Certificate

   See PKCS#6 Appendix A for a description of X.509 certificate abstract syntax
   and signing procedures.

   The certificate encoded below has identical subject and issuer names

   Subject: Country = US, Organization = VeriSign, Inc., Organizational Unit = Class 1 Public Primary Certification Authority
   Issuer: Country = US, Organization = VeriSign, Inc., Organizational Unit = Class 1 Public Primary Certification Authority

   A certificate object may be initialized using the following code fragment:

   certItem1.data = CLASS1_ROOT_SELF_SIGNED_CERT;
   certItem1.len = sizeof (CLASS1_ROOT_SELF_SIGNED_CERT);
        
   if ((status = SetCertBER
            (class1CertObject, &certItem1, (ERROR_CTX *)NULL_PTR)) != 0)
     break;
 */

unsigned char CLASS1_ROOT_SELF_SIGNED_CERT[566] = {
 0x30, 0x82, 0x02, 0x31, 0x30, 0x82, 0x01, 0x9a, 0x02, 0x05, 0x02, 0xa4, 0x00, 0x00, 0x01, 0x30,
 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x02, 0x05, 0x00, 0x30, 0x5f,
 0x31, 0x0b, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 0x55, 0x53, 0x31, 0x17, 0x30,
 0x15, 0x06, 0x03, 0x55, 0x04, 0x0a, 0x13, 0x0e, 0x56, 0x65, 0x72, 0x69, 0x53, 0x69, 0x67, 0x6e,
 0x2c, 0x20, 0x49, 0x6e, 0x63, 0x2e, 0x31, 0x37, 0x30, 0x35, 0x06, 0x03, 0x55, 0x04, 0x0b, 0x13,
 0x2e, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x20, 0x31, 0x20, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x20,
 0x50, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x20, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x30,
 0x1e, 0x17, 0x0d, 0x39, 0x36, 0x30, 0x31, 0x32, 0x39, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a,
 0x17, 0x0d, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32, 0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30,
 0x5f, 0x31, 0x0b, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 0x55, 0x53, 0x31, 0x17,
 0x30, 0x15, 0x06, 0x03, 0x55, 0x04, 0x0a, 0x13, 0x0e, 0x56, 0x65, 0x72, 0x69, 0x53, 0x69, 0x67,
 0x6e, 0x2c, 0x20, 0x49, 0x6e, 0x63, 0x2e, 0x31, 0x37, 0x30, 0x35, 0x06, 0x03, 0x55, 0x04, 0x0b,
 0x13, 0x2e, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x20, 0x31, 0x20, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63,
 0x20, 0x50, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x20, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79,
 0x30, 0x81, 0x9f, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x01,
 0x05, 0x00, 0x03, 0x81, 0x8d, 0x00, 0x30, 0x81, 0x89, 0x02, 0x81, 0x81, 0x00, 0xe5, 0x19, 0xbf,
 0x6d, 0xa3, 0x56, 0x61, 0x2d, 0x99, 0x48, 0x71, 0xf6, 0x67, 0xde, 0xb9, 0x8d, 0xeb, 0xb7, 0x9e,
 0x86, 0x80, 0x0a, 0x91, 0x0e, 0xfa, 0x38, 0x25, 0xaf, 0x46, 0x88, 0x82, 0xe5, 0x73, 0xa8, 0xa0,
 0x9b, 0x24, 0x5d, 0x0d, 0x1f, 0xcc, 0x65, 0x6e, 0x0c, 0xb0, 0xd0, 0x56, 0x84, 0x18, 0x87, 0x9a,
 0x06, 0x9b, 0x10, 0xa1, 0x73, 0xdf, 0xb4, 0x58, 0x39, 0x6b, 0x6e, 0xc1, 0xf6, 0x15, 0xd5, 0xa8,
 0xa8, 0x3f, 0xaa, 0x12, 0x06, 0x8d, 0x31, 0xac, 0x7f, 0xb0, 0x34, 0xd7, 0x8f, 0x34, 0x67, 0x88,
 0x09, 0xcd, 0x14, 0x11, 0xe2, 0x4e, 0x45, 0x56, 0x69, 0x1f, 0x78, 0x02, 0x80, 0xda, 0xdc, 0x47,
 0x91, 0x29, 0xbb, 0x36, 0xc9, 0x63, 0x5c, 0xc5, 0xe0, 0xd7, 0x2d, 0x87, 0x7b, 0xa1, 0xb7, 0x32,
 0xb0, 0x7b, 0x30, 0xba, 0x2a, 0x2f, 0x31, 0xaa, 0xee, 0xa3, 0x67, 0xda, 0xdb, 0x02, 0x03, 0x01,
 0x00, 0x01, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x02, 0x05,
 0x00, 0x03, 0x81, 0x81, 0x00, 0x52, 0x73, 0xba, 0x9a, 0x55, 0xdc, 0xdc, 0x3f, 0x82, 0x7d, 0xb0,
 0x90, 0x98, 0x62, 0x2a, 0x82, 0x4c, 0x76, 0x00, 0x6e, 0x25, 0x3d, 0xd5, 0xc2, 0x09, 0x70, 0x57,
 0x01, 0x0c, 0x0f, 0x77, 0x1f, 0x18, 0xa1, 0xfb, 0x1c, 0x60, 0x0e, 0xa0, 0x75, 0x3b, 0x49, 0x21,
 0x41, 0xfe, 0xa7, 0x5c, 0x2d, 0x4c, 0x42, 0x49, 0xd3, 0xff, 0x28, 0xd8, 0x8c, 0xea, 0x9d, 0xfe,
 0xc9, 0x07, 0xe2, 0x77, 0x82, 0x53, 0x23, 0xde, 0x55, 0xf3, 0xce, 0x44, 0x93, 0xfa, 0xfa, 0x4c,
 0xbd, 0xca, 0x36, 0xf3, 0x5b, 0x66, 0xb2, 0x9e, 0xc8, 0xf2, 0x0c, 0x5e, 0x5e, 0xd4, 0xa1, 0xb4,
 0x21, 0x09, 0x33, 0xca, 0x3b, 0x59, 0xfc, 0x92, 0xc2, 0x38, 0xfc, 0xad, 0xd9, 0x96, 0x24, 0xe0,
 0x2d, 0xfa, 0xa3, 0x29, 0xf5, 0x33, 0x68, 0x78, 0x4e, 0xb4, 0xbc, 0x9f, 0x69, 0x35, 0xe2, 0xa8,
 0x98, 0x94, 0x73, 0x3b, 0xc4, 0x00
};

static char __license1[] = "NOTICE: THE USE OF THIS VERISIGN CERTIFICATE IS \
SUBJECT TO THE VERISIGN CERTIFICATION PRACTICE STATEMENT LOCATED AT \
http://www.verisign.com/repository/CPS OR AVAILABLE FROM: VeriSign, Inc.\
2593 Coast Ave.; Mountain View, CA 94043; (415) 961-7500.";

/*
   VERISIGN, INC. LICENSE AGREEMENT

  IMPORTANT - READ CAREFULLY BEFORE DOWNLOADING OR INSTALLING

  This file lists the VeriSign, Inc. ("VeriSign") Class 2 Certification
  Authority Distinguished Name and Public Key information (the "Information").
  BY DOWNLOADING OR INSTALLING THE INFORMATION, YOU INDICATE YOUR ACCEPTANCE
  OF THIS LICENSE.  IF YOU DO NOT AGREE TO ALL OF THE TERMS OF THIS LICENSE,
  DO NOT DOWNLOAD OR USE THE INFORMATION.

  1.   License and Limitations.  VeriSign grants you a royalty-free license to
  use, copy and distribute the Information or any compiled derivative of it,
  subject to the terms of this License.  You must reproduce and include this
  entire License and VeriSign's copyright notices and trademarks on each copy
  of the Information and compiled derivative of it.  VeriSign retains all
  ownership of the Information and all intellectual property rights therein.

  2.   No Warranty.  VeriSign provides the Information "AS IS" and makes no
  warranties, expressed or implied, about the Information or the use thereof.
  WITHOUT LIMITATION, VERISIGN DISCLAIMS ANY IMPLIED WARRANTIES OF
  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT OF
  THIRD PARTY RIGHTS.

  3.   Limitation of Liability.  VeriSign's entire liability to you under this
  License shall be limited to a maximum of $10.00.  IN NO EVENT SHALL VERISIGN
  BE LIABLE TO YOU OR TO ANY OTHER PERSON FOR ANY SPECIAL, INCIDENTAL OR
  CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE THE
  INFORMATION.

  4.   General.  This License is governed by the laws of the State of California
  and is the complete and exclusive statement of your agreement with VeriSign
  with respect to the Information.  You acknowledge that the Information is
  being provided to you without charge and that this is reflected in the
  absence of warranties and limitations of liability in this License.

  5.   NOTICE: THE USE OF THIS VERISIGN CERTIFICATE IS SUBJECT TO THE
  VERISIGN CERTIFICATION PRACTICE STATEMENT LOCATED AT
       http://www.verisign.com/repository/CPS
  OR AVAILABLE FROM:
     VeriSign, Inc.
     2593 Coast Ave.
     Mountain View, CA 94043
     (415) 961-7500

  Code Fragments and ASN.1 discussion are taken from the PKCS standards
  published by RSA Data Security, Inc.

  Copyright 1995 VeriSign, Inc. All Rights Reserved.
*/

/* VeriSign Class 2 Root Subject Name (BER Encoded)

  This section gives the ASN.1 notation for the X.501 type
  Name.

  Name ::= CHOICE {
              RDNSequence }

   RDNSequence ::= SEQUENCE OF RelativeDistinguishedName

   RelativeDistinguishedName ::=
     SET OF AttributeValueAssertion

   AttributeValueAssertion ::= SEQUENCE {
      AttributeType,
      AttributeValue }

   AttributeType ::= OBJECT IDENTIFIER

   AttributeValue ::= ANY

   The Name type identifies an object in an X.500 directory.  Name is
   a CHOICE type consisting of one alternative: RDNSequence. (Future
   revisions of X.500 may have other alternatives.)

   The RDNSequence type gives a path through an X.500 directory tree
   starting at the root. RDNSequence is a SEQUENCE OF type consisting
   of zero or more occurences of RelativeDistinguishedName.

   The RelativeDistinguishedName type gives a unique name to an object
   relative to the object superior to it in the directory
   tree. RelativeDistinguishedName is a SET OF type consisting of zero
   or more occurrences of AttributeValueAssertion.

   The AttributeValueAssertion type assigns a value to some attribute
   of a relative distinguished name, such as country name or common
   name. AttributeValueAssertion is a SEQUENCE type consisting of two
   components, an AttributeType type and an AttributeValue type.

   The AttributeType type identifies an attribute by object
   identifier. The AttributeValue type gives an arbitrary attribute
   value. The actual type of the attribute value is determined by the
   attribute type.

   The specific ASN.1 value encoded below represents the following
   name:
      Country = US
      Organization = VeriSign, Inc.
      Organizational Unit = Class 2 Public Primary Certification Authority

   Using the TIPEM toolkit the following string would be used to initilize a
   name object:

       if ((status = SetNameBER
                                 (class2RootSubjectName, CLASS2_ROOT_SUBJECT_NAME, sizeof (CLASS2_ROOT_SUBJECT_NAME), (ERROR_CTX *)NULL_PTR)) != 0)
         break;
 */

unsigned char CLASS2_ROOT_SUBJECT_NAME[97] = {
 0x30, 0x5f, 0x31, 0x0b, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 0x55, 0x53, 0x31,
 0x17, 0x30, 0x15, 0x06, 0x03, 0x55, 0x04, 0x0a, 0x13, 0x0e, 0x56, 0x65, 0x72, 0x69, 0x53, 0x69,
 0x67, 0x6e, 0x2c, 0x20, 0x49, 0x6e, 0x63, 0x2e, 0x31, 0x37, 0x30, 0x35, 0x06, 0x03, 0x55, 0x04,
 0x0b, 0x13, 0x2e, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x20, 0x32, 0x20, 0x50, 0x75, 0x62, 0x6c, 0x69,
 0x63, 0x20, 0x50, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x20, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66,
 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74,
 0x79
};


/* VeriSign Class 2 Root Subject Public Key

   subjectPublicKeyInfo contains information about the public key
   being certified. The information identifies the entity's public-key
   algorithm (and any associated parameters); examples of public-key
   algorithms include X.509's rsa and PKCS #1's rsaEncryption. The
   information also includes a bit- string representation of the
   entity's public key.  For both public-key algorithms just
   mentioned, the bit string contains the BER encoding of a value of
   X.509/PKCS #1 type RSAPublicKey.

   SubjectPublicKeyInfo ::= SEQUENCE {
     algorithm AlgorithmIdentifier,
     subjectPublicKey BIT STRING }

   AlgorithmIdentifier ::= SEQUENCE {
     algorithm OBJECT IDENTIFIER,
     parameters ANY DEFINED BY ALGORITHM OPTIONAL }

   The name and subject public key contained below may be added to a TIPEM
   root list using the following function:

   if (status = AddMeRoot
       (&class2MeIndex, meSet, CLASS2_ROOT_SUBJECT_NAME, sizeof (CLASS2_ROOT_SUBJECT_NAME), 
        CLASS2_ROOT_SUBJECT_PUBLIC_KEY, sizeof (CLASS2_ROOT_SUBJECT_PUBLIC_KEY)))
     break;
 */

unsigned char CLASS2_ROOT_SUBJECT_PUBLIC_KEY[165] = {
 0x30, 0x81, 0x9f, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x01,
 0x05, 0x00, 0x03, 0x81, 0x8d, 0x00, 0x30, 0x81, 0x89, 0x02, 0x81, 0x81, 0x00, 0xb6, 0x5a, 0x8b,
 0xa3, 0x0d, 0x6a, 0x23, 0x83, 0x80, 0x6b, 0xcf, 0x39, 0x87, 0xf4, 0x21, 0x13, 0x33, 0x06, 0x4c,
 0x25, 0xa2, 0xed, 0x55, 0x12, 0x97, 0xc5, 0xa7, 0x80, 0xb9, 0xfa, 0x83, 0xc1, 0x20, 0xa0, 0xfa,
 0x2f, 0x15, 0x0d, 0x7c, 0xa1, 0x60, 0x6b, 0x7e, 0x79, 0x2c, 0xfa, 0x06, 0x0f, 0x3a, 0xae, 0xf6,
 0x1b, 0x6f, 0xb1, 0xd2, 0xff, 0x2f, 0x28, 0x52, 0x5f, 0x83, 0x7d, 0x4b, 0xc4, 0x7a, 0xb7, 0xf8,
 0x66, 0x1f, 0x80, 0x54, 0xfc, 0xb7, 0xc2, 0x8e, 0x59, 0x4a, 0x14, 0x57, 0x46, 0xd1, 0x9a, 0x93,
 0xbe, 0x41, 0x91, 0x03, 0xbb, 0x15, 0x80, 0x93, 0x5c, 0xeb, 0xe7, 0xcc, 0x08, 0x6c, 0x3f, 0x3e,
 0xb3, 0x4a, 0xfc, 0xff, 0x4b, 0x6c, 0x23, 0xd5, 0x50, 0x82, 0x26, 0x44, 0x19, 0x8e, 0x23, 0xc3,
 0x71, 0xea, 0x19, 0x24, 0x47, 0x04, 0x9e, 0x75, 0xbf, 0xc8, 0xa6, 0x00, 0x1f, 0x02, 0x03, 0x01,
 0x00, 0x01
};

/* VeriSign Class 2 Root Self-Signed Certificate

   See PKCS#6 Appendix A for a description of X.509 certificate abstract syntax
   and signing procedures.

   The certificate encoded below has identical subject and issuer names

   Subject: Country = US, Organization = VeriSign, Inc., Organizational Unit = Class 1 Public Primary Certification Authority
   Issuer: Country = US, Organization = VeriSign, Inc., Organizational Unit = Class 1 Public Primary Certification Authority

   A certificate object may be initialized using the following code fragment:

   certItem2.data = CLASS2_ROOT_SELF_SIGNED_CERT;
   certItem2.len = sizeof (CLASS2_ROOT_SELF_SIGNED_CERT);
        
   if ((status = SetCertBER
            (class2CertObject, &certItem2, (ERROR_CTX *)NULL_PTR)) != 0)
     break;
*/

unsigned char CLASS2_ROOT_SELF_SIGNED_CERT[566] = {
 0x30, 0x82, 0x02, 0x31, 0x30, 0x82, 0x01, 0x9a, 0x02, 0x05, 0x02, 0xa3, 0x00, 0x00, 0x01, 0x30,
 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x02, 0x05, 0x00, 0x30, 0x5f,
 0x31, 0x0b, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 0x55, 0x53, 0x31, 0x17, 0x30,
 0x15, 0x06, 0x03, 0x55, 0x04, 0x0a, 0x13, 0x0e, 0x56, 0x65, 0x72, 0x69, 0x53, 0x69, 0x67, 0x6e,
 0x2c, 0x20, 0x49, 0x6e, 0x63, 0x2e, 0x31, 0x37, 0x30, 0x35, 0x06, 0x03, 0x55, 0x04, 0x0b, 0x13,
 0x2e, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x20, 0x32, 0x20, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x20,
 0x50, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x20, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x30,
 0x1e, 0x17, 0x0d, 0x39, 0x36, 0x30, 0x31, 0x32, 0x39, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a,
 0x17, 0x0d, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32, 0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30,
 0x5f, 0x31, 0x0b, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 0x55, 0x53, 0x31, 0x17,
 0x30, 0x15, 0x06, 0x03, 0x55, 0x04, 0x0a, 0x13, 0x0e, 0x56, 0x65, 0x72, 0x69, 0x53, 0x69, 0x67,
 0x6e, 0x2c, 0x20, 0x49, 0x6e, 0x63, 0x2e, 0x31, 0x37, 0x30, 0x35, 0x06, 0x03, 0x55, 0x04, 0x0b,
 0x13, 0x2e, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x20, 0x32, 0x20, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63,
 0x20, 0x50, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x20, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79,
 0x30, 0x81, 0x9f, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x01,
 0x05, 0x00, 0x03, 0x81, 0x8d, 0x00, 0x30, 0x81, 0x89, 0x02, 0x81, 0x81, 0x00, 0xb6, 0x5a, 0x8b,
 0xa3, 0x0d, 0x6a, 0x23, 0x83, 0x80, 0x6b, 0xcf, 0x39, 0x87, 0xf4, 0x21, 0x13, 0x33, 0x06, 0x4c,
 0x25, 0xa2, 0xed, 0x55, 0x12, 0x97, 0xc5, 0xa7, 0x80, 0xb9, 0xfa, 0x83, 0xc1, 0x20, 0xa0, 0xfa,
 0x2f, 0x15, 0x0d, 0x7c, 0xa1, 0x60, 0x6b, 0x7e, 0x79, 0x2c, 0xfa, 0x06, 0x0f, 0x3a, 0xae, 0xf6,
 0x1b, 0x6f, 0xb1, 0xd2, 0xff, 0x2f, 0x28, 0x52, 0x5f, 0x83, 0x7d, 0x4b, 0xc4, 0x7a, 0xb7, 0xf8,
 0x66, 0x1f, 0x80, 0x54, 0xfc, 0xb7, 0xc2, 0x8e, 0x59, 0x4a, 0x14, 0x57, 0x46, 0xd1, 0x9a, 0x93,
 0xbe, 0x41, 0x91, 0x03, 0xbb, 0x15, 0x80, 0x93, 0x5c, 0xeb, 0xe7, 0xcc, 0x08, 0x6c, 0x3f, 0x3e,
 0xb3, 0x4a, 0xfc, 0xff, 0x4b, 0x6c, 0x23, 0xd5, 0x50, 0x82, 0x26, 0x44, 0x19, 0x8e, 0x23, 0xc3,
 0x71, 0xea, 0x19, 0x24, 0x47, 0x04, 0x9e, 0x75, 0xbf, 0xc8, 0xa6, 0x00, 0x1f, 0x02, 0x03, 0x01,
 0x00, 0x01, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x02, 0x05,
 0x00, 0x03, 0x81, 0x81, 0x00, 0x7b, 0xaf, 0xa4, 0x1c, 0x2f, 0xc0, 0x9b, 0x0e, 0x3b, 0x5c, 0xfc,
 0xa8, 0xe6, 0xd1, 0x96, 0x0f, 0x48, 0x72, 0x49, 0x85, 0xe5, 0xaf, 0x1a, 0x23, 0x00, 0xe3, 0xe9,
 0xbb, 0x80, 0x34, 0x6c, 0xb2, 0x3f, 0x84, 0xa8, 0x3c, 0x72, 0x70, 0xb3, 0x4c, 0xde, 0x73, 0xfa,
 0x7c, 0x84, 0xd2, 0x92, 0xa5, 0x00, 0x37, 0x09, 0xc2, 0x03, 0x34, 0x23, 0x03, 0xb7, 0xed, 0x76,
 0x96, 0xdc, 0x3e, 0x4f, 0x85, 0xfd, 0x58, 0x17, 0xf4, 0x04, 0xbe, 0xec, 0x51, 0x1e, 0xdc, 0x7a,
 0xdb, 0xdb, 0xae, 0xe8, 0x61, 0x78, 0xda, 0x65, 0x38, 0x47, 0xac, 0x1d, 0x03, 0x70, 0x6d, 0xe9,
 0xe3, 0xbb, 0xa0, 0x4a, 0x9f, 0x40, 0xea, 0xbc, 0xdb, 0x73, 0xbf, 0x67, 0x4d, 0x5d, 0xc6, 0x7c,
 0x20, 0x5c, 0xe7, 0xe8, 0xa2, 0x0a, 0x2b, 0xc2, 0x09, 0x74, 0xd7, 0x4c, 0xfe, 0xdb, 0xe9, 0x6b,
 0x02, 0x63, 0x5d, 0x39, 0xa7, 0x00
};

static char __license2[] = "NOTICE: THE USE OF THIS VERISIGN CERTIFICATE IS \
SUBJECT TO THE VERISIGN CERTIFICATION PRACTICE STATEMENT LOCATED AT \
http://www.verisign.com/repository/CPS OR AVAILABLE FROM: VeriSign, Inc.\
2593 Coast Ave.; Mountain View, CA 94043; (415) 961-7500.";

/*
   VERISIGN, INC. LICENSE AGREEMENT

  IMPORTANT - READ CAREFULLY BEFORE DOWNLOADING OR INSTALLING

  This file lists the VeriSign, Inc. ("VeriSign") Class 3 Certification
  Authority Distinguished Name and Public Key information (the "Information").
  BY DOWNLOADING OR INSTALLING THE INFORMATION, YOU INDICATE YOUR ACCEPTANCE
  OF THIS LICENSE.  IF YOU DO NOT AGREE TO ALL OF THE TERMS OF THIS LICENSE,
  DO NOT DOWNLOAD OR USE THE INFORMATION.

  1.   License and Limitations.  VeriSign grants you a royalty-free license to
  use, copy and distribute the Information or any compiled derivative of it,
  subject to the terms of this License.  You must reproduce and include this
  entire License and VeriSign's copyright notices and trademarks on each copy
  of the Information and compiled derivative of it.  VeriSign retains all
  ownership of the Information and all intellectual property rights therein.

  2.   No Warranty.  VeriSign provides the Information "AS IS" and makes no
  warranties, expressed or implied, about the Information or the use thereof.
  WITHOUT LIMITATION, VERISIGN DISCLAIMS ANY IMPLIED WARRANTIES OF
  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT OF
  THIRD PARTY RIGHTS.

  3.   Limitation of Liability.  VeriSign's entire liability to you under this
  License shall be limited to a maximum of $10.00.  IN NO EVENT SHALL VERISIGN
  BE LIABLE TO YOU OR TO ANY OTHER PERSON FOR ANY SPECIAL, INCIDENTAL OR
  CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE THE
  INFORMATION.

  4.   General.  This License is governed by the laws of the State of California
  and is the complete and exclusive statement of your agreement with VeriSign
  with respect to the Information.  You acknowledge that the Information is
  being provided to you without charge and that this is reflected in the
  absence of warranties and limitations of liability in this License.

  5.   NOTICE: THE USE OF THIS VERISIGN CERTIFICATE IS SUBJECT TO THE
  VERISIGN CERTIFICATION PRACTICE STATEMENT LOCATED AT
       http://www.verisign.com/repository/CPS
  OR AVAILABLE FROM:
     VeriSign, Inc.
     2593 Coast Ave.
     Mountain View, CA 94043
     (415) 961-7500

  Code Fragments and ASN.1 discussion are taken from the PKCS standards
  published by RSA Data Security, Inc.

  Copyright 1995 VeriSign, Inc. All Rights Reserved.
*/

/* VeriSign Class 3 Root Subject Name (BER Encoded)

  This section gives the ASN.1 notation for the X.501 type
  Name.

  Name ::= CHOICE {
              RDNSequence }

   RDNSequence ::= SEQUENCE OF RelativeDistinguishedName

   RelativeDistinguishedName ::=
     SET OF AttributeValueAssertion

   AttributeValueAssertion ::= SEQUENCE {
      AttributeType,
      AttributeValue }

   AttributeType ::= OBJECT IDENTIFIER

   AttributeValue ::= ANY

   The Name type identifies an object in an X.500 directory.  Name is
   a CHOICE type consisting of one alternative: RDNSequence. (Future
   revisions of X.500 may have other alternatives.)

   The RDNSequence type gives a path through an X.500 directory tree
   starting at the root. RDNSequence is a SEQUENCE OF type consisting
   of zero or more occurences of RelativeDistinguishedName.

   The RelativeDistinguishedName type gives a unique name to an object
   relative to the object superior to it in the directory
   tree. RelativeDistinguishedName is a SET OF type consisting of zero
   or more occurrences of AttributeValueAssertion.

   The AttributeValueAssertion type assigns a value to some attribute
   of a relative distinguished name, such as country name or common
   name. AttributeValueAssertion is a SEQUENCE type consisting of two
   components, an AttributeType type and an AttributeValue type.

   The AttributeType type identifies an attribute by object
   identifier. The AttributeValue type gives an arbitrary attribute
   value. The actual type of the attribute value is determined by the
   attribute type.

   The specific ASN.1 value encoded below represents the following
   name:
      Country = US
      Organization = VeriSign, Inc.
      Organizational Unit = Class 3 Public Primary Certification Authority

   Using the TIPEM toolkit the following string would be used to initilize a
   name object:

   if ((status = SetNameBER
              (class3RootSubjectName, CLASS3_ROOT_SUBJECT_NAME, sizeof (CLASS3_ROOT_SUBJECT_NAME), (ERROR_CTX *)NULL_PTR)) != 0)
     break;
 */

unsigned char CLASS3_ROOT_SUBJECT_NAME[97] = {
 0x30, 0x5f, 0x31, 0x0b, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 0x55, 0x53, 0x31,
 0x17, 0x30, 0x15, 0x06, 0x03, 0x55, 0x04, 0x0a, 0x13, 0x0e, 0x56, 0x65, 0x72, 0x69, 0x53, 0x69,
 0x67, 0x6e, 0x2c, 0x20, 0x49, 0x6e, 0x63, 0x2e, 0x31, 0x37, 0x30, 0x35, 0x06, 0x03, 0x55, 0x04,
 0x0b, 0x13, 0x2e, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x20, 0x33, 0x20, 0x50, 0x75, 0x62, 0x6c, 0x69,
 0x63, 0x20, 0x50, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x20, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66,
 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74,
 0x79
};


/* VeriSign Class 3 Root Subject Public Key

   subjectPublicKeyInfo contains information about the public key
   being certified. The information identifies the entity's public-key
   algorithm (and any associated parameters); examples of public-key
   algorithms include X.509's rsa and PKCS #1's rsaEncryption. The
   information also includes a bit- string representation of the
   entity's public key.  For both public-key algorithms just
   mentioned, the bit string contains the BER encoding of a value of
   X.509/PKCS #1 type RSAPublicKey.

   SubjectPublicKeyInfo ::= SEQUENCE {
     algorithm AlgorithmIdentifier,
     subjectPublicKey BIT STRING }

   AlgorithmIdentifier ::= SEQUENCE {
     algorithm OBJECT IDENTIFIER,
     parameters ANY DEFINED BY ALGORITHM OPTIONAL }

   The name and subject public key contained below may be added to a TIPEM
   root list using the following function:

   if (status = AddMeRoot
       (&class3MeIndex, meSet, CLASS3_ROOT_SUBJECT_NAME, sizeof (CLASS3_ROOT_SUBJECT_NAME), 
        CLASS3_ROOT_SUBJECT_PUBLIC_KEY, sizeof (CLASS3_ROOT_SUBJECT_PUBLIC_KEY)))
     break;
*/

unsigned char CLASS3_ROOT_SUBJECT_PUBLIC_KEY[165] = {
 0x30, 0x81, 0x9f, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x01,
 0x05, 0x00, 0x03, 0x81, 0x8d, 0x00, 0x30, 0x81, 0x89, 0x02, 0x81, 0x81, 0x00, 0xc9, 0x5c, 0x59,
 0x9e, 0xf2, 0x1b, 0x8a, 0x01, 0x14, 0xb4, 0x10, 0xdf, 0x04, 0x40, 0xdb, 0xe3, 0x57, 0xaf, 0x6a,
 0x45, 0x40, 0x8f, 0x84, 0x0c, 0x0b, 0xd1, 0x33, 0xd9, 0xd9, 0x11, 0xcf, 0xee, 0x02, 0x58, 0x1f,
 0x25, 0xf7, 0x2a, 0xa8, 0x44, 0x05, 0xaa, 0xec, 0x03, 0x1f, 0x78, 0x7f, 0x9e, 0x93, 0xb9, 0x9a,
 0x00, 0xaa, 0x23, 0x7d, 0xd6, 0xac, 0x85, 0xa2, 0x63, 0x45, 0xc7, 0x72, 0x27, 0xcc, 0xf4, 0x4c,
 0xc6, 0x75, 0x71, 0xd2, 0x39, 0xef, 0x4f, 0x42, 0xf0, 0x75, 0xdf, 0x0a, 0x90, 0xc6, 0x8e, 0x20,
 0x6f, 0x98, 0x0f, 0xf8, 0xac, 0x23, 0x5f, 0x70, 0x29, 0x36, 0xa4, 0xc9, 0x86, 0xe7, 0xb1, 0x9a,
 0x20, 0xcb, 0x53, 0xa5, 0x85, 0xe7, 0x3d, 0xbe, 0x7d, 0x9a, 0xfe, 0x24, 0x45, 0x33, 0xdc, 0x76,
 0x15, 0xed, 0x0f, 0xa2, 0x71, 0x64, 0x4c, 0x65, 0x2e, 0x81, 0x68, 0x45, 0xa7, 0x02, 0x03, 0x01,
 0x00, 0x01
};

/* VeriSign Class 3 Root Self-Signed Certificate

   See PKCS#6 Appendix A for a description of X.509 certificate abstract syntax
   and signing procedures.

   The certificate encoded below has identical subject and issuer names

   Subject: Country = US, Organization = VeriSign, Inc., Organizational Unit = Class 3 Public Primary Certification Authority
   Issuer: Country = US, Organization = VeriSign, Inc., Organizational Unit = Class 3 Public Primary Certification Authority

   A certificate object may be initialized using the following code fragment:

   certItem3.data = CLASS3_ROOT_SELF_SIGNED_CERT;
   certItem3.len = sizeof (CLASS3_ROOT_SELF_SIGNED_CERT);
        
   if ((status = SetCertBER
            (class3CertObject, &certItem3, (ERROR_CTX *)NULL_PTR)) != 0)
     break;
 */

unsigned char CLASS3_ROOT_SELF_SIGNED_CERT[566] = {
 0x30, 0x82, 0x02, 0x31, 0x30, 0x82, 0x01, 0x9a, 0x02, 0x05, 0x02, 0xa1, 0x00, 0x00, 0x01, 0x30,
 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x02, 0x05, 0x00, 0x30, 0x5f,
 0x31, 0x0b, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 0x55, 0x53, 0x31, 0x17, 0x30,
 0x15, 0x06, 0x03, 0x55, 0x04, 0x0a, 0x13, 0x0e, 0x56, 0x65, 0x72, 0x69, 0x53, 0x69, 0x67, 0x6e,
 0x2c, 0x20, 0x49, 0x6e, 0x63, 0x2e, 0x31, 0x37, 0x30, 0x35, 0x06, 0x03, 0x55, 0x04, 0x0b, 0x13,
 0x2e, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x20, 0x33, 0x20, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x20,
 0x50, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x20, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x30,
 0x1e, 0x17, 0x0d, 0x39, 0x36, 0x30, 0x31, 0x32, 0x39, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a,
 0x17, 0x0d, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32, 0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30,
 0x5f, 0x31, 0x0b, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 0x55, 0x53, 0x31, 0x17,
 0x30, 0x15, 0x06, 0x03, 0x55, 0x04, 0x0a, 0x13, 0x0e, 0x56, 0x65, 0x72, 0x69, 0x53, 0x69, 0x67,
 0x6e, 0x2c, 0x20, 0x49, 0x6e, 0x63, 0x2e, 0x31, 0x37, 0x30, 0x35, 0x06, 0x03, 0x55, 0x04, 0x0b,
 0x13, 0x2e, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x20, 0x33, 0x20, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63,
 0x20, 0x50, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x20, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79,
 0x30, 0x81, 0x9f, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x01,
 0x05, 0x00, 0x03, 0x81, 0x8d, 0x00, 0x30, 0x81, 0x89, 0x02, 0x81, 0x81, 0x00, 0xc9, 0x5c, 0x59,
 0x9e, 0xf2, 0x1b, 0x8a, 0x01, 0x14, 0xb4, 0x10, 0xdf, 0x04, 0x40, 0xdb, 0xe3, 0x57, 0xaf, 0x6a,
 0x45, 0x40, 0x8f, 0x84, 0x0c, 0x0b, 0xd1, 0x33, 0xd9, 0xd9, 0x11, 0xcf, 0xee, 0x02, 0x58, 0x1f,
 0x25, 0xf7, 0x2a, 0xa8, 0x44, 0x05, 0xaa, 0xec, 0x03, 0x1f, 0x78, 0x7f, 0x9e, 0x93, 0xb9, 0x9a,
 0x00, 0xaa, 0x23, 0x7d, 0xd6, 0xac, 0x85, 0xa2, 0x63, 0x45, 0xc7, 0x72, 0x27, 0xcc, 0xf4, 0x4c,
 0xc6, 0x75, 0x71, 0xd2, 0x39, 0xef, 0x4f, 0x42, 0xf0, 0x75, 0xdf, 0x0a, 0x90, 0xc6, 0x8e, 0x20,
 0x6f, 0x98, 0x0f, 0xf8, 0xac, 0x23, 0x5f, 0x70, 0x29, 0x36, 0xa4, 0xc9, 0x86, 0xe7, 0xb1, 0x9a,
 0x20, 0xcb, 0x53, 0xa5, 0x85, 0xe7, 0x3d, 0xbe, 0x7d, 0x9a, 0xfe, 0x24, 0x45, 0x33, 0xdc, 0x76,
 0x15, 0xed, 0x0f, 0xa2, 0x71, 0x64, 0x4c, 0x65, 0x2e, 0x81, 0x68, 0x45, 0xa7, 0x02, 0x03, 0x01,
 0x00, 0x01, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x02, 0x05,
 0x00, 0x03, 0x81, 0x81, 0x00, 0x75, 0x66, 0x6c, 0x3e, 0xd1, 0xcd, 0x81, 0xdb, 0xb5, 0xf8, 0x2f,
 0x36, 0x51, 0xb6, 0xf7, 0x42, 0xbc, 0xcd, 0x42, 0xaf, 0xdc, 0x0e, 0xfa, 0x15, 0x6c, 0xf8, 0x67,
 0x93, 0x57, 0x3a, 0xeb, 0xb6, 0x92, 0xe8, 0xb6, 0x01, 0xca, 0x8c, 0xb7, 0x8e, 0x43, 0xb4, 0x49,
 0x65, 0xf9, 0x3e, 0xee, 0xbd, 0x75, 0x46, 0x2e, 0xc9, 0xfc, 0x25, 0x5d, 0xa8, 0xc7, 0x2f, 0x8b,
 0x9b, 0x8f, 0x68, 0xcf, 0xb4, 0x9c, 0x97, 0x18, 0xc0, 0x4d, 0xef, 0x1f, 0xd9, 0xaf, 0x82, 0xb3,
 0xe6, 0x64, 0xb8, 0x84, 0x5c, 0x8a, 0x9a, 0x07, 0x52, 0x43, 0x61, 0xfb, 0x74, 0x9e, 0x5b, 0x3a,
 0x36, 0xfc, 0x4c, 0xb2, 0xfc, 0x1a, 0x3f, 0x15, 0x2e, 0xa5, 0x5b, 0x3c, 0x1b, 0x90, 0xec, 0x88,
 0x29, 0xe4, 0x59, 0x16, 0xf9, 0xce, 0x07, 0xad, 0xec, 0xe9, 0xdd, 0xda, 0xd2, 0x31, 0x8a, 0x4f,
 0xd6, 0xd8, 0xef, 0x17, 0x8d, 0x00
};


static char __license3[] = "NOTICE: THE USE OF THIS VERISIGN CERTIFICATE IS \
SUBJECT TO THE VERISIGN CERTIFICATION PRACTICE STATEMENT LOCATED AT \
http://www.verisign.com/repository/CPS OR AVAILABLE FROM: VeriSign, Inc.\
2593 Coast Ave.; Mountain View, CA 94043; (415) 961-7500.";

/*
   VERISIGN, INC. LICENSE AGREEMENT

  IMPORTANT - READ CAREFULLY BEFORE DOWNLOADING OR INSTALLING

  This file lists the VeriSign, Inc. ("VeriSign") Class 4 Certification
  Authority Distinguished Name and Public Key information (the "Information").
  BY DOWNLOADING OR INSTALLING THE INFORMATION, YOU INDICATE YOUR ACCEPTANCE
  OF THIS LICENSE.  IF YOU DO NOT AGREE TO ALL OF THE TERMS OF THIS LICENSE,
  DO NOT DOWNLOAD OR USE THE INFORMATION.

  1.   License and Limitations.  VeriSign grants you a royalty-free license to
  use, copy and distribute the Information or any compiled derivative of it,
  subject to the terms of this License.  You must reproduce and include this
  entire License and VeriSign's copyright notices and trademarks on each copy
  of the Information and compiled derivative of it.  VeriSign retains all
  ownership of the Information and all intellectual property rights therein.

  2.   No Warranty.  VeriSign provides the Information "AS IS" and makes no
  warranties, expressed or implied, about the Information or the use thereof.
  WITHOUT LIMITATION, VERISIGN DISCLAIMS ANY IMPLIED WARRANTIES OF
  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT OF
  THIRD PARTY RIGHTS.

  3.   Limitation of Liability.  VeriSign's entire liability to you under this
  License shall be limited to a maximum of $10.00.  IN NO EVENT SHALL VERISIGN
  BE LIABLE TO YOU OR TO ANY OTHER PERSON FOR ANY SPECIAL, INCIDENTAL OR
  CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE THE
  INFORMATION.

  4.   General.  This License is governed by the laws of the State of California
  and is the complete and exclusive statement of your agreement with VeriSign
  with respect to the Information.  You acknowledge that the Information is
  being provided to you without charge and that this is reflected in the
  absence of warranties and limitations of liability in this License.

  5.   NOTICE: THE USE OF THIS VERISIGN CERTIFICATE IS SUBJECT TO THE
  VERISIGN CERTIFICATION PRACTICE STATEMENT LOCATED AT
       http://www.verisign.com/repository/CPS
  OR AVAILABLE FROM:
     VeriSign, Inc.
     2593 Coast Ave.
     Mountain View, CA 94043
     (415) 961-7500

  Code Fragments and ASN.1 discussion are taken from the PKCS standards
  published by RSA Data Security, Inc.

  Copyright 1995 VeriSign, Inc. All Rights Reserved.
*/


/* VeriSign Class 4 Root Subject Name (BER Encoded)

  This section gives the ASN.1 notation for the X.501 type
  Name.

  Name ::= CHOICE {
              RDNSequence }

   RDNSequence ::= SEQUENCE OF RelativeDistinguishedName

   RelativeDistinguishedName ::=
     SET OF AttributeValueAssertion

   AttributeValueAssertion ::= SEQUENCE {
      AttributeType,
      AttributeValue }

   AttributeType ::= OBJECT IDENTIFIER

   AttributeValue ::= ANY

   The Name type identifies an object in an X.500 directory.  Name is
   a CHOICE type consisting of one alternative: RDNSequence. (Future
   revisions of X.500 may have other alternatives.)

   The RDNSequence type gives a path through an X.500 directory tree
   starting at the root. RDNSequence is a SEQUENCE OF type consisting
   of zero or more occurences of RelativeDistinguishedName.

   The RelativeDistinguishedName type gives a unique name to an object
   relative to the object superior to it in the directory
   tree. RelativeDistinguishedName is a SET OF type consisting of zero
   or more occurrences of AttributeValueAssertion.

   The AttributeValueAssertion type assigns a value to some attribute
   of a relative distinguished name, such as country name or common
   name. AttributeValueAssertion is a SEQUENCE type consisting of two
   components, an AttributeType type and an AttributeValue type.

   The AttributeType type identifies an attribute by object
   identifier. The AttributeValue type gives an arbitrary attribute
   value. The actual type of the attribute value is determined by the
   attribute type.

   The specific ASN.1 value encoded below represents the following
   name:
      Country = US
      Organization = VeriSign, Inc.
      Organizational Unit = Class 4 Public Primary Certification Authority

   Using the TIPEM toolkit the following string would be used to initilize a
   name object:

   if ((status = SetNameBER
              (class4RootSubjectName, CLASS4_ROOT_SUBJECT_NAME, sizeof (CLASS4_ROOT_SUBJECT_NAME), (ERROR_CTX *)NULL_PTR)) != 0)
     break;
 */

unsigned char CLASS4_ROOT_SUBJECT_NAME[97] = {
 0x30, 0x5f, 0x31, 0x0b, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 0x55, 0x53, 0x31,
 0x17, 0x30, 0x15, 0x06, 0x03, 0x55, 0x04, 0x0a, 0x13, 0x0e, 0x56, 0x65, 0x72, 0x69, 0x53, 0x69,
 0x67, 0x6e, 0x2c, 0x20, 0x49, 0x6e, 0x63, 0x2e, 0x31, 0x37, 0x30, 0x35, 0x06, 0x03, 0x55, 0x04,
 0x0b, 0x13, 0x2e, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x20, 0x34, 0x20, 0x50, 0x75, 0x62, 0x6c, 0x69,
 0x63, 0x20, 0x50, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x20, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66,
 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74,
 0x79
};


/* VeriSign Class 4 Root Subject Public Key

   subjectPublicKeyInfo contains information about the public key
   being certified. The information identifies the entity's public-key
   algorithm (and any associated parameters); examples of public-key
   algorithms include X.509's rsa and PKCS #1's rsaEncryption. The
   information also includes a bit- string representation of the
   entity's public key.  For both public-key algorithms just
   mentioned, the bit string contains the BER encoding of a value of
   X.509/PKCS #1 type RSAPublicKey.

   SubjectPublicKeyInfo ::= SEQUENCE {
     algorithm AlgorithmIdentifier,
     subjectPublicKey BIT STRING }

   AlgorithmIdentifier ::= SEQUENCE {
     algorithm OBJECT IDENTIFIER,
     parameters ANY DEFINED BY ALGORITHM OPTIONAL }

   The name and subject public key contained below may be added to a TIPEM
   root list using the following function:

   if (status = AddMeRoot
       (&class4MeIndex, meSet, CLASS4_ROOT_SUBJECT_NAME, sizeof (CLASS4_ROOT_SUBJECT_NAME), 
        CLASS4_ROOT_SUBJECT_PUBLIC_KEY, sizeof (CLASS4_ROOT_SUBJECT_PUBLIC_KEY)))
     break;
 */

unsigned char CLASS4_ROOT_SUBJECT_PUBLIC_KEY[165] = {
 0x30, 0x81, 0x9f, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x01,
 0x05, 0x00, 0x03, 0x81, 0x8d, 0x00, 0x30, 0x81, 0x89, 0x02, 0x81, 0x81, 0x00, 0xd0, 0xb2, 0x75,
 0xf6, 0x78, 0xd0, 0xae, 0x5a, 0x50, 0xf4, 0xe9, 0x50, 0xa9, 0x9f, 0x8c, 0xd7, 0xef, 0x91, 0x94,
 0x70, 0xe8, 0xd2, 0x24, 0x90, 0x76, 0x89, 0x85, 0xd6, 0xdf, 0xac, 0xe6, 0x01, 0x17, 0x32, 0x80,
 0xf0, 0x9d, 0x93, 0x47, 0xbc, 0x9a, 0x65, 0x9d, 0x1f, 0x97, 0xae, 0xbf, 0xe9, 0x86, 0x75, 0x63,
 0x20, 0x89, 0xbd, 0x80, 0x58, 0x9d, 0x04, 0x0c, 0x9d, 0xa8, 0xc1, 0x24, 0xe9, 0x0b, 0xe5, 0x31,
 0x78, 0xbd, 0xfc, 0x2d, 0x0c, 0x37, 0x6a, 0x9e, 0x78, 0x80, 0xe9, 0x46, 0x75, 0xf9, 0xed, 0xa3,
 0xfb, 0x13, 0x7b, 0xc8, 0xc1, 0x4c, 0xd2, 0xa3, 0xef, 0xf5, 0x3c, 0xb0, 0x62, 0x8f, 0x4a, 0x5d,
 0x3b, 0xdd, 0x95, 0x67, 0x8f, 0x13, 0xb9, 0xc1, 0x3c, 0xd6, 0xa7, 0x26, 0x9b, 0xec, 0xc3, 0x3b,
 0x7a, 0xd9, 0x4d, 0xbc, 0x6d, 0x9b, 0xe8, 0x15, 0x01, 0xe3, 0xf0, 0x47, 0xa9, 0x02, 0x03, 0x01,
 0x00, 0x01 
};

/* VeriSign Class 4 Root Self-Signed Certificate

   See PKCS#6 Appendix A for a description of X.509 certificate abstract syntax
   and signing procedures.

   The certificate encoded below has identical subject and issuer names

   Subject: Country = US, Organization = VeriSign, Inc., Organizational Unit = Class 4 Public Primary Certification Authority
   Issuer: Country = US, Organization = VeriSign, Inc., Organizational Unit = Class 4 Public Primary Certification Authority

   A certificate object may be initialized using the following code fragment:

   certItem4.data = CLASS4_ROOT_SELF_SIGNED_CERT;
   certItem4.len = sizeof (CLASS4_ROOT_SELF_SIGNED_CERT);
        
   if ((status = SetCertBER
            (class4CertObject, &certItem4, (ERROR_CTX *)NULL_PTR)) != 0)
     break;
 */

unsigned char CLASS4_ROOT_SELF_SIGNED_CERT[566] = {
 0x30, 0x82, 0x02, 0x31, 0x30, 0x82, 0x01, 0x9a, 0x02, 0x05, 0x02, 0xa6, 0x00, 0x00, 0x01, 0x30,
 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x02, 0x05, 0x00, 0x30, 0x5f,
 0x31, 0x0b, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 0x55, 0x53, 0x31, 0x17, 0x30,
 0x15, 0x06, 0x03, 0x55, 0x04, 0x0a, 0x13, 0x0e, 0x56, 0x65, 0x72, 0x69, 0x53, 0x69, 0x67, 0x6e,
 0x2c, 0x20, 0x49, 0x6e, 0x63, 0x2e, 0x31, 0x37, 0x30, 0x35, 0x06, 0x03, 0x55, 0x04, 0x0b, 0x13,
 0x2e, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x20, 0x34, 0x20, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x20,
 0x50, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x20, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x30,
 0x1e, 0x17, 0x0d, 0x39, 0x36, 0x30, 0x31, 0x32, 0x39, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a,
 0x17, 0x0d, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32, 0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30,
 0x5f, 0x31, 0x0b, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 0x55, 0x53, 0x31, 0x17,
 0x30, 0x15, 0x06, 0x03, 0x55, 0x04, 0x0a, 0x13, 0x0e, 0x56, 0x65, 0x72, 0x69, 0x53, 0x69, 0x67,
 0x6e, 0x2c, 0x20, 0x49, 0x6e, 0x63, 0x2e, 0x31, 0x37, 0x30, 0x35, 0x06, 0x03, 0x55, 0x04, 0x0b,
 0x13, 0x2e, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x20, 0x34, 0x20, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63,
 0x20, 0x50, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x20, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79,
 0x30, 0x81, 0x9f, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x01,
 0x05, 0x00, 0x03, 0x81, 0x8d, 0x00, 0x30, 0x81, 0x89, 0x02, 0x81, 0x81, 0x00, 0xd0, 0xb2, 0x75,
 0xf6, 0x78, 0xd0, 0xae, 0x5a, 0x50, 0xf4, 0xe9, 0x50, 0xa9, 0x9f, 0x8c, 0xd7, 0xef, 0x91, 0x94,
 0x70, 0xe8, 0xd2, 0x24, 0x90, 0x76, 0x89, 0x85, 0xd6, 0xdf, 0xac, 0xe6, 0x01, 0x17, 0x32, 0x80,
 0xf0, 0x9d, 0x93, 0x47, 0xbc, 0x9a, 0x65, 0x9d, 0x1f, 0x97, 0xae, 0xbf, 0xe9, 0x86, 0x75, 0x63,
 0x20, 0x89, 0xbd, 0x80, 0x58, 0x9d, 0x04, 0x0c, 0x9d, 0xa8, 0xc1, 0x24, 0xe9, 0x0b, 0xe5, 0x31,
 0x78, 0xbd, 0xfc, 0x2d, 0x0c, 0x37, 0x6a, 0x9e, 0x78, 0x80, 0xe9, 0x46, 0x75, 0xf9, 0xed, 0xa3,
 0xfb, 0x13, 0x7b, 0xc8, 0xc1, 0x4c, 0xd2, 0xa3, 0xef, 0xf5, 0x3c, 0xb0, 0x62, 0x8f, 0x4a, 0x5d,
 0x3b, 0xdd, 0x95, 0x67, 0x8f, 0x13, 0xb9, 0xc1, 0x3c, 0xd6, 0xa7, 0x26, 0x9b, 0xec, 0xc3, 0x3b,
 0x7a, 0xd9, 0x4d, 0xbc, 0x6d, 0x9b, 0xe8, 0x15, 0x01, 0xe3, 0xf0, 0x47, 0xa9, 0x02, 0x03, 0x01,
 0x00, 0x01, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x02, 0x05,
 0x00, 0x03, 0x81, 0x81, 0x00, 0x53, 0xdd, 0xd3, 0xf0, 0x9c, 0x24, 0x7e, 0x40, 0xaa, 0xe2, 0xfc,
 0x00, 0x1a, 0xd7, 0xda, 0x0c, 0xfc, 0x32, 0x61, 0xb8, 0x15, 0x0d, 0x96, 0xf3, 0xfa, 0x57, 0x1b,
 0x7f, 0x33, 0x7c, 0xaf, 0xe9, 0x98, 0x9a, 0x61, 0xc8, 0x7a, 0xb3, 0xb7, 0xff, 0xb1, 0xdc, 0x99,
 0x83, 0xdc, 0xac, 0x12, 0xfc, 0x70, 0xc9, 0x1f, 0x38, 0x42, 0xed, 0x44, 0xf6, 0x80, 0x2e, 0x5b,
 0x6b, 0x33, 0x69, 0xac, 0x9c, 0xd3, 0x5c, 0xe7, 0x5f, 0x5a, 0x18, 0xc7, 0xb1, 0x2d, 0x79, 0x04,
 0x96, 0x41, 0x91, 0x99, 0x41, 0xb1, 0x3c, 0x0d, 0xba, 0x84, 0x39, 0xc6, 0x3b, 0x97, 0xf0, 0x26,
 0xc9, 0x8e, 0xee, 0xbd, 0xcc, 0x42, 0x95, 0xff, 0x1e, 0xc7, 0x02, 0x3f, 0x54, 0x0c, 0x78, 0xf5,
 0xbc, 0xaa, 0x60, 0x7c, 0x02, 0x69, 0xe8, 0xdc, 0xac, 0xe2, 0x02, 0x76, 0x61, 0xc4, 0x3e, 0x03,
 0xea, 0xd2, 0x8a, 0x24, 0xd1, 0x00
};


static char __license4[] = "NOTICE: THE USE OF THIS VERISIGN CERTIFICATE IS \
SUBJECT TO THE VERISIGN CERTIFICATION PRACTICE STATEMENT LOCATED AT \
http://www.verisign.com/repository/CPS OR AVAILABLE FROM: VeriSign, Inc.\
2593 Coast Ave.; Mountain View, CA 94043; (415) 961-7500.";
