/* Copyright Dr S.N.Henson 1997 */

#include <stdio.h>
#include <stdlib.h>
#include <objects.h>
#include <asn1.h>
#include <asn1_mac.h>
#include <x509.h>
#include <pkcs7.h>
#include <err.h>
#include <stack.h>
#include <crypto.h>
#include "pfx.h"

SUP_DATA *SUP_DATA_new()
{
	SUP_DATA *ret=NULL;
	M_ASN1_New_Malloc(ret, SUP_DATA);
	ret->prints = NULL;
	ret->regen = NULL;
	ret->nickname = NULL;
	ret->additional = NULL;
	return (ret);
	M_ASN1_New_Error(504);
}

SUP_DATA *d2i_SUP_DATA(a,pp,length)
SUP_DATA **a;
unsigned char **pp;
long length;
{
	M_ASN1_D2I_vars(a,SUP_DATA *,SUP_DATA_new);
	M_ASN1_D2I_Init();
	M_ASN1_D2I_start_sequence();
	M_ASN1_D2I_get_set (ret->prints, d2i_X509_SIG);
	/*M_ASN1_D2I_get (ret->regen, d2i_ASN1_TYPE);*/
	c.q=c.p;
	if(!d2i_ASN1_bytes (&ret->nickname, &c.p, c.slen, V_ASN1_BMPSTRING,
		V_ASN1_UNIVERSAL)) goto err;
	c.slen-=(c.p-c.q);
	M_ASN1_D2I_get_seq_opt (ret->additional, d2i_ASN1_TYPE);
	M_ASN1_D2I_Finish(a, SUP_DATA_free, 503);
}

void SUP_DATA_free (a)
SUP_DATA *a;
{
	if(a==NULL) return;
	sk_pop_free (a->prints, X509_SIG_free);
	sk_pop_free (a->additional, ASN1_TYPE_free);
	Free ((char *)a);
}
