/* Copyright Dr S.N.Henson 1997 */
#include <stdio.h>
#include <stdlib.h>
#include <objects.h>
#include <asn1.h>
#include <asn1_mac.h>
#include <x509.h>
#include <pkcs7.h>
#include <err.h>
#include <stack.h>
#include <crypto.h>
#include "pfx.h"

PRIV_KEY_INFO *PRIV_KEY_INFO_new()
{
	PRIV_KEY_INFO *ret=NULL;
	M_ASN1_New_Malloc(ret, PRIV_KEY_INFO);
	ret->version = NULL;
	ret->pkeyalg = NULL;
	ret->pkey = NULL;
	ret->attributes = NULL;
	return (ret);
	M_ASN1_New_Error(502);
}

PRIV_KEY_INFO *d2i_PRIV_KEY_INFO(a,pp,length)
PRIV_KEY_INFO **a;
unsigned char **pp;
long length;
{
	M_ASN1_D2I_vars(a,PRIV_KEY_INFO *,PRIV_KEY_INFO_new);
	M_ASN1_D2I_Init();
	M_ASN1_D2I_start_sequence();
	M_ASN1_D2I_get (ret->version, d2i_ASN1_INTEGER);
	M_ASN1_D2I_get (ret->pkeyalg, d2i_X509_ALGOR);
	M_ASN1_D2I_get (ret->pkey, d2i_ASN1_OCTET_STRING);
	M_ASN1_D2I_get_IMP_set_opt (ret->attributes, d2i_ASN1_TYPE, 0);
	M_ASN1_D2I_Finish(a, PRIV_KEY_INFO_free, 503);
}

void PRIV_KEY_INFO_free (a)
PRIV_KEY_INFO *a;
{
	if (a == NULL) return;
	ASN1_INTEGER_free (a->version);
	X509_ALGOR_free (a->pkeyalg);
	ASN1_OCTET_STRING_free (a->pkey);
	sk_pop_free (a->attributes, ASN1_TYPE_free);
	Free ((char *)a);
}
