/* Copyright Dr S.N.Henson 1997 */
#include <stdio.h>
#include <stdlib.h>
#include <err.h>
#include <crypto.h>
#include <evp.h>
#include <string.h>
#include <pkcs7.h>
#include "pfx.h"


void p_SHA1 (end, endlen, secret, secretlen, seed, seedlen)
unsigned char *end, *secret, *seed;
int endlen, seedlen, secretlen;
{
	unsigned char *tmpbuf;
	unsigned char dig[20];
	unsigned char an[20];
	bzero (an, 20);
	bcopy (seed, an, seedlen);
	tmpbuf = malloc (100);
	while (endlen > 0) {
		bcopy (an, tmpbuf, 20);
		bcopy (seed, tmpbuf + 20, seedlen);
		HMAC_SHA1 (secret, secretlen, tmpbuf, 20 + seedlen, 64, dig);
		bcopy (dig, end, 20);
		end += 20;
		endlen -= 20;
		HMAC_SHA1 (secret, secretlen, an, 20, 64, an);
	}
		
}

unsigned char *vpasswd (pass, salt, saltlen, oplen)
unsigned char *pass;
unsigned char *salt;
int saltlen;
int *oplen;
{
	char *uni, *unipass;
	int plen, i;
	plen = strlen (pass);
	uni = malloc ((plen<<1) + saltlen + 2);
	if (!uni) return NULL;
	bzero (uni, (plen<<1) + saltlen + 2);
	unipass = uni + saltlen + 1;
	bcopy (salt, uni, saltlen);
	for (i = 0; i < plen; i++) unipass[i<<1] = pass[i];
	if (oplen) *oplen = (plen<<1) + saltlen + 2;
	return uni;
}
	
void HMAC_SHA1 (key, keylen, data, datalen, blocklen, md)
unsigned char *key;
int keylen;
unsigned char *data;
int datalen;
unsigned char *md;
{
	SHA_CTX c;
	int i;
	unsigned char *keytmp;
	unsigned char *digtmp;
	keytmp = malloc (blocklen);
	digtmp = malloc (SHA_DIGEST_LENGTH);
	bzero (keytmp, blocklen);
	bcopy (key, keytmp, keylen);
	for (i = 0; i < blocklen; i++) keytmp[i] ^=0x36;
	SHA1_Init (&c);
	SHA1_Update (&c, keytmp, blocklen);
	SHA1_Update (&c, data, datalen);
	SHA1_Final (digtmp, &c);
	bzero (keytmp, blocklen);
	bcopy (key, keytmp, keylen);
	for (i = 0; i < blocklen; i++) keytmp[i] ^=0x5c;
	SHA1_Init (&c);
	SHA1_Update (&c, keytmp, blocklen);
	SHA1_Update (&c, digtmp, SHA_DIGEST_LENGTH);
	SHA1_Final (md, &c);
	free (keytmp);
	free (digtmp);
}	

void PKCS5_KEY_GEN (pass, passlen, salt, saltlen, iter, md)
unsigned char *pass;
int passlen;
unsigned char *salt;
int saltlen;
int iter;
unsigned char *md;
{
	int i;
	unsigned char zeropad[20];
	SHA_CTX c;
	SHA1_Init (&c);
	SHA1_Update (&c, pass, passlen);
	if (saltlen) SHA1_Update (&c, salt, saltlen);
	if (saltlen + passlen < 20 ) {
		bzero (zeropad, 20);
		SHA1_Update (&c, zeropad, 20 - saltlen - passlen);
	}
	SHA1_Final (md, &c);
	for (i = 1; i < iter; i++) {
		SHA1_Init (&c);
		SHA1_Update (&c, md, SHA_DIGEST_LENGTH);
		SHA1_Final (md, &c);
	}
}
