/* Copyright Dr S.N.Henson 1997 */
#include <stdio.h>
#include <stdlib.h>
#include <objects.h>
#include <asn1.h>
#include <asn1_mac.h>
#include <x509.h>
#include <pkcs7.h>
#include <err.h>
#include <stack.h>
#include <crypto.h>
#include "pfx.h"

PFX *d2i_PFX(a,pp,length)
PFX **a;
unsigned char **pp;
long length;
{
	M_ASN1_D2I_vars(a,PFX *,PFX_new);
	M_ASN1_D2I_Init();
	M_ASN1_D2I_start_sequence();
	M_ASN1_D2I_get_IMP_opt (ret->mac, d2i_MAC_DATA, 0, V_ASN1_SEQUENCE);
	M_ASN1_D2I_get_IMP_opt (ret->authsafe, d2i_PKCS7, 1, V_ASN1_SEQUENCE);
	M_ASN1_D2I_Finish(a, PFX_free, 500);
}

PFX *PFX_new()
{
	PFX *ret=NULL;
	M_ASN1_New_Malloc(ret, PFX);
	ret->mac=NULL;
	ret->authsafe=NULL;
	ret->bags = NULL;
	return (ret);
	M_ASN1_New_Error(501);
}

void PFX_free (a)
PFX *a;
{
	if (a == NULL) return;
	MAC_DATA_free (a->mac);
	PKCS7_free (a->authsafe);
	Free ((char *)a);
}
