/* Copyright Dr S.N.Henson 1997 */
#include <stdio.h>
#include <stdlib.h>
#include <objects.h>
#include <asn1.h>
#include <asn1_mac.h>
#include <x509.h>
#include <pkcs7.h>
#include <err.h>
#include <stack.h>
#include <crypto.h>
#include "pfx.h"

ESPVK *d2i_ESPVK(a,pp,length)
ESPVK **a;
unsigned char **pp;
long length;
{
	M_ASN1_D2I_vars(a,ESPVK *,ESPVK_new);
	M_ASN1_D2I_Init();
	M_ASN1_D2I_start_sequence();
	M_ASN1_D2I_get (ret->espvkoid, d2i_ASN1_OBJECT);
	M_ASN1_D2I_get (ret->supdata, d2i_SUP_DATA);
	M_ASN1_D2I_get_EXP_opt (ret->cipher, d2i_ENCPKEY, 0);
	M_ASN1_D2I_Finish(a, ESPVK_free, 504);
}

ESPVK *ESPVK_new ()
{
	ESPVK *ret=NULL;
	M_ASN1_New_Malloc(ret, ESPVK);
	ret->espvkoid = NULL;
	ret->supdata = NULL;
	ret->cipher = NULL;
	ret->pkey = NULL;
	return (ret);
	M_ASN1_New_Error(504);
}

void ESPVK_free (a)
ESPVK *a;
{
	if(a==NULL) return;
	ASN1_OBJECT_free (a->espvkoid);
	SUP_DATA_free (a->supdata);
	ENCPKEY_free (a->cipher);
	PRIV_KEY_INFO_free (a->pkey);
	Free ((char *)a);
}
