/* Copyright Dr S.N.Henson 1997 */
#include <stdio.h>
#include <stdlib.h>
#include <objects.h>
#include <pkcs7.h>
#include <err.h>
#include <crypto.h>
#include <sha.h>
#include <stack.h>
#include <evp.h>
#include <string.h>
#include "pfx.h"

/* Verify the mac */
int verify_mac (pass, p)
char *pass;
PFX *p;
{
    unsigned char dig[20], *vpass;
    int ret, vplen;
    ASN1_OCTET_STRING *safe, *macsalt;
    safe = p->authsafe->d.data;
    macsalt = p->mac->salt;
    vpass = vpasswd(pass, macsalt->data, macsalt->length, &vplen);

/* No this is not a bug, it simulates the salt prepended twice */
    PKCS5_KEY_GEN (macsalt->data, macsalt->length, vpass, vplen, 1, dig);

    HMAC_SHA1 (dig+4, 16, safe->data, safe->length, 64, dig);

    if ((p->mac->dinfo->digest->length != SHA_DIGEST_LENGTH) ||
	bcmp (dig, p->mac->dinfo->digest->data, SHA_DIGEST_LENGTH)) ret = 1; 
    else ret = 0;
    free (vpass);
    return ret;
}

/* Decrypt private keys and add them to ESPVK struct */
int decrypt_pkeys (bags, pass)
STACK *bags;
char *pass;
{
int i, j;
BAGITEM *tmpbag;
ESPVK *tmpsbag;
PRIV_KEY_INFO *pinf;
PBEPARAM *pbe;
EVP_CIPHER_CTX ctx;
unsigned char *tbuf;
unsigned char keyiv[80], dig[20];
unsigned char *debuf, *p;
int delen, ok, tmplen;

/* Get all private keys */
for (i = 0; i < sk_num (bags); i++)
	for (j = 0, tmpbag = (BAGITEM *) sk_value (bags, i) ;
				 j < sk_num (tmpbag->espvks); j++) {

	/* Bug: need to check ESPVKOID in here */
    tmpsbag = (ESPVK *) sk_value (tmpbag->espvks, j);

        /* Extract pbe parameters */
    tbuf = tmpsbag->cipher->algor->parameter->value.sequence->data;
    pbe = d2i_PBEPARAM (NULL, &tbuf, 
		tmpsbag->cipher->algor->parameter->value.sequence->length);

    /* Initialise decryption */
    debuf = malloc (tmpsbag->cipher->epkey->length + 8);

    /* Generate keys: BUG assumes triple DES here. */
    PKCS5_KEY_GEN (pass, strlen (pass), pbe->salt->data, pbe->salt->length,
					ASN1_INTEGER_get (pbe->iter), dig); 
    p_SHA1 (keyiv, 40, dig, 20, pbe->salt->data, pbe->salt->length);

    /* Decrypt private key */
    EVP_DecryptInit (&ctx, EVP_des_ede3_cbc(), keyiv, keyiv + 32);
    EVP_DecryptUpdate (&ctx, debuf, &delen, tmpsbag->cipher->epkey->data,
					 tmpsbag->cipher->epkey->length);
    ok = EVP_DecryptFinal (&ctx, debuf + delen, &tmplen);
    delen += tmplen;
    p = debuf;
    if (!ok) return 1;

    /* Parse structure and add to safebag */
    pinf = d2i_PRIV_KEY_INFO (NULL, &p, delen);
    if (!pinf) return 1;
    free (debuf);
    PBEPARAM_free (pbe);
    /* Add to ESPVK structure */
    tmpsbag->pkey = pinf;

  }
  return 0;
} 

STACK *decrypt_safe (pfx, asafe, pass)
PFX *pfx;
AUTHSAFE *asafe;
char *pass;
{
	X509_ALGOR *algor;
	ASN1_OCTET_STRING *safe_enc;
	PBEPARAM *pbe;
	STACK *tstk;
	unsigned char *pbuf, *vpass;
	unsigned char *out;
	int vplen, outlen, i, ok;
	char dig[20];
	EVP_CIPHER_CTX ctx;

	/* Extract useful info from authentisafe */
	algor = asafe->safe->d.encrypted->enc_data->algorithm;
	safe_enc = asafe->safe->d.encrypted->enc_data->enc_data;
	pbuf = (char *) algor->parameter->value.sequence->data;
	pbe = d2i_PBEPARAM (NULL, &pbuf,
				 algor->parameter->value.sequence->length);
	if (!pbe) return NULL;

	out = malloc (safe_enc->length + 8);
	/* Generate the decryption key */
	vpass = vpasswd (pass, asafe->psalt->data,
						 asafe->psalt->length, &vplen);
	PKCS5_KEY_GEN (vpass, vplen, pbe->salt->data,
			 pbe->salt->length, ASN1_INTEGER_get(pbe->iter), dig);

	/* Try to decrypt safe */
	/* BUG: assumes RC2-40 here */
	EVP_DecryptInit (&ctx, EVP_rc2_cbc(), NULL, dig+12);
	/* Evil hack: force key to 40 bits */
	RC2_set_key (&ctx.c.rc2_cbc.ks, 5, dig, 40);
	EVP_DecryptUpdate (&ctx, out, &i, safe_enc->data, safe_enc->length);
	outlen = i;
	ok = EVP_DecryptFinal (&ctx, out + i, &i);

	if (!ok) {
		free (out);
		free (vpass);
		return NULL;
	}

	outlen += i;
	pbuf = out;
	/* Parse safe */
	tstk = d2i_ASN1_SET (&pfx->bags, &pbuf, outlen,
		 (char *(*)())d2i_SAFEBAG, V_ASN1_SET, V_ASN1_UNIVERSAL);

	free (out);
	free (vpass);
	return (tstk);

}
